/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.ui.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import tigase.util.ui.console.ConsoleIfc;

public class SystemConsole
implements ConsoleIfc {
    private final BufferedReader in;
    private final PrintWriter out;

    public SystemConsole() {
        if (System.console() != null) {
            this.in = null;
            this.out = System.console().writer();
        } else {
            this.in = new BufferedReader(new InputStreamReader(System.in));
            this.out = new PrintWriter(System.out, true);
        }
    }

    @Override
    public String readLine() {
        if (this.in == null) {
            return System.console().readLine();
        }
        try {
            return this.in.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public String readLine(String label) {
        if (this.in == null) {
            return System.console().readLine("%s", label);
        }
        try {
            this.out.printf("%s", label);
            return this.in.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public char[] readPassword(String label) {
        if (this.in == null) {
            return System.console().readPassword("%s", label);
        }
        String line = this.readLine(label);
        return line.toCharArray();
    }

    @Override
    public void writeLine(String format, Object ... args) {
        this.out.printf(format + "\n", args);
    }

    @Override
    public void writeLine(Object obj) {
        this.out.println(obj);
    }
}

