/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.dns;

import tigase.util.dns.DNSResolverDefault;
import tigase.util.dns.DNSResolverIfc;

public class DNSResolverFactory {
    public static final String TIGASE_RESOLVER_CLASS = "tigase-resolver-class";
    private static final System.Logger log = System.getLogger(DNSResolverFactory.class.getName());
    private static volatile DNSResolverIfc instance = null;

    public static DNSResolverIfc getInstance() {
        return instance;
    }

    public static void setDnsResolverClassName(String property) {
        Class<?> clazz = null;
        try {
            if (property != null) {
                clazz = Class.forName(property);
            }
            if (clazz != null) {
                instance = (DNSResolverIfc)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            log.log(System.Logger.Level.ERROR, "Failed initialization of class: {0} (property: {1}), using default: {2}", clazz, property, DNSResolverDefault.class.getCanonicalName());
        }
        if (instance == null) {
            instance = new DNSResolverDefault();
        }
    }

    static {
        DNSResolverFactory.setDnsResolverClassName(System.getProperty(TIGASE_RESOLVER_CLASS));
    }
}

