/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.datetime;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimestampHelper {
    private final DateTimeFormatter TIMESTAMP_ISO_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffsetId().toFormatter();
    private final DateTimeFormatter TIMESTAMP_ISO_DATE_TIMEMS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffsetId().toFormatter();
    private final DateTimeFormatter TIMESTAMP_ISO_ZONED_DATE_TIME = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    private final DateTimeFormatter TIMESTAMP_LEGACY = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private boolean useUTC;

    public TimestampHelper() {
        this.useUTC = true;
    }

    public TimestampHelper(boolean useUTC) {
        this.useUTC = useUTC;
    }

    private String format(DateTimeFormatter formatter, Date time) {
        ZonedDateTime zdt = time.toInstant().atZone(ZoneOffset.UTC);
        if (this.useUTC) {
            return zdt.withZoneSameInstant(ZoneOffset.UTC).format(formatter);
        }
        return zdt.withZoneSameInstant(ZoneId.systemDefault()).format(formatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date ts) {
        DateTimeFormatter dateTimeFormatter = this.TIMESTAMP_ISO_DATE_TIME;
        synchronized (dateTimeFormatter) {
            return this.format(this.TIMESTAMP_ISO_DATE_TIME, ts);
        }
    }

    public String formatInLegacyDelayedDelivery(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTimeZone(TimeZone.getTimeZone("GMT"));
        now.setTime(date);
        return String.format("%1$tY%1$tm%1$tdT%1$tH:%1$tM:%1$tS", now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatWithMs(Date ts) {
        DateTimeFormatter dateTimeFormatter = this.TIMESTAMP_ISO_DATE_TIMEMS;
        synchronized (dateTimeFormatter) {
            return this.format(this.TIMESTAMP_ISO_DATE_TIMEMS, ts);
        }
    }

    public boolean isUseUTC() {
        return this.useUTC;
    }

    public void setUseUTC(boolean useUTC) {
        this.useUTC = useUTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseTimestamp(String tmp) throws ParseException {
        if (tmp == null || tmp.isEmpty()) {
            return null;
        }
        try {
            if (!tmp.contains("-")) {
                DateTimeFormatter dateTimeFormatter = this.TIMESTAMP_LEGACY;
                synchronized (dateTimeFormatter) {
                    LocalDateTime dt = LocalDateTime.parse(tmp, this.TIMESTAMP_LEGACY);
                    return Date.from(dt.toInstant(ZoneOffset.UTC));
                }
            }
            DateTimeFormatter dateTimeFormatter = this.TIMESTAMP_ISO_ZONED_DATE_TIME;
            synchronized (dateTimeFormatter) {
                ZonedDateTime dt = ZonedDateTime.parse(tmp, this.TIMESTAMP_ISO_ZONED_DATE_TIME);
                return Date.from(dt.toInstant());
            }
        }
        catch (DateTimeParseException e) {
            throw new ParseException(e.getMessage(), e.getErrorIndex());
        }
    }
}

