/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Arrays;

public class StringUtilities {
    private static final char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};

    public static boolean checkIfArrayContainsString(char[] data, char[] string) {
        return StringUtilities.checkIfArrayContainsString(data, 0, string);
    }

    public static boolean checkIfArrayContainsString(char[] data, int fromIndex, char[] string) {
        if (data == null || string.length > data.length + fromIndex) {
            return false;
        }
        for (int position = 0; position < string.length; ++position) {
            if (data[position + fromIndex] == string[position]) continue;
            return false;
        }
        return true;
    }

    public static String convertNonPrintableCharactersToLiterals(String input) {
        return StringUtilities.convertNonPrintableCharactersToLiterals(input, false);
    }

    public static String convertNonPrintableCharactersToLiterals(String input, boolean maintainWhitespace) {
        StringBuilder output = new StringBuilder();
        block4: for (char c : input.toCharArray()) {
            switch (Character.getType(c)) {
                case 0: 
                case 16: 
                case 18: 
                case 19: {
                    output.append("\\u").append(String.format("%04X", c));
                    continue block4;
                }
                case 15: {
                    if (maintainWhitespace && Arrays.binarySearch(WHITE_CHARS, c) >= 0) {
                        output.append(c);
                        continue block4;
                    }
                    output.append("\\u").append(String.format("%04X", c));
                    continue block4;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String intArrayToString(int[] arr, String separator) {
        if (arr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String[] internStringArray(String[] in) {
        String[] result = null;
        if (in != null) {
            result = new String[in.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = in[i].intern();
            }
        }
        return result;
    }

    public static StringBuilder padString(StringBuilder sb, String text, int width) {
        return StringUtilities.padString(sb, text, JUSTIFY.LEFT, width, ' ', null, null);
    }

    public static StringBuilder padString(StringBuilder sb, String text, int width, String leftBracket, String rightBracket) {
        return StringUtilities.padString(sb, text, JUSTIFY.LEFT, width, ' ', leftBracket, rightBracket);
    }

    public static StringBuilder padString(StringBuilder sb, String text, JUSTIFY justify, int width, char padChar, String leftBracket, String rightBracket) {
        if (leftBracket != null && !leftBracket.isEmpty()) {
            sb.append(leftBracket);
        }
        int textLength = text.length();
        int padSize = width - textLength;
        switch (justify.ordinal()) {
            case 0: {
                sb.append(text);
                while (padSize-- > 0) {
                    sb.append(padChar);
                }
                break;
            }
            case 2: {
                while (padSize-- > 0) {
                    sb.append(padChar);
                }
                sb.append(text);
                break;
            }
            case 1: {
                int leftPad = (int)Math.floor((double)padSize / 2.0);
                while (leftPad-- > 0) {
                    sb.append(padChar);
                }
                sb.append(text);
                int rightPad = (int)Math.ceil((double)padSize / 2.0);
                while (rightPad-- > 0) {
                    sb.append(padChar);
                }
                break;
            }
        }
        if (rightBracket != null && !rightBracket.isEmpty()) {
            sb.append(rightBracket);
        }
        return sb;
    }

    public static StringBuilder padStringToColumn(StringBuilder sb, String text, JUSTIFY justify, int column, char padChar, String leftBracket, String rightBracket) {
        return StringUtilities.padString(sb, text, justify, column - sb.length(), padChar, leftBracket, rightBracket);
    }

    public static String stringArrayToString(String[] arr, String separator) {
        if (arr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String[] stringToArrayOfString(String in, String splitter) {
        String[] result = null;
        if (in != null) {
            result = in.split(splitter);
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].intern();
            }
        }
        return result;
    }

    public static enum JUSTIFY {
        LEFT,
        CENTRE,
        RIGHT;

    }
}

