/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import tigase.util.ClassComparator;
import tigase.util.ObjectComparator;

public class ClassUtil {
    private static final System.Logger log = System.getLogger(ClassUtil.class.getName());
    private static final String[] SKIP_WHITELIST = new String[]{"tigase."};
    private static final String[] SKIP_CONTAINS = new String[]{".ui.", ".swing", ".awt", ".sql.", ".xml.", ".terracotta."};
    private static final String META_VERSION_PREFIX = "META-INF.versions.";
    private static final String[] SKIP_STARTS = new String[]{"com.mysql", "tigase.pubsub.Utils", "org.apache.derby", "org.apache.xml", "org.postgresql", "com.sun", "groovy", "org.codehaus.groovy", "org.netbeans", "org.python"};
    private static final int RUNTIME_FEATURE_VERSION = Runtime.version().feature();

    public static String getClassNameFromFileName(String fileName) {
        String class_name = null;
        if (fileName.endsWith(".class")) {
            String tmp_class_name = fileName.substring(0, fileName.length() - 6).replace('\\', '.');
            class_name = tmp_class_name.replace('/', '.');
        }
        return class_name;
    }

    public static Set<String> getClassNamesFromDir(File dir) {
        Set<String> tmp_set = ClassUtil.getFileListDeep(dir);
        TreeSet<String> result = new TreeSet<String>();
        for (String elem : tmp_set) {
            String class_name = ClassUtil.getClassNameFromFileName(elem);
            if (class_name == null) continue;
            result.add(class_name);
        }
        return result;
    }

    public static Set<String> getClassNamesFromJar(File jarFile) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> jar_entries = jar.entries();
            while (jar_entries.hasMoreElements()) {
                JarEntry jar_entry = jar_entries.nextElement();
                String class_name = ClassUtil.getClassNameFromFileName(jar_entry.getName());
                if (class_name == null) continue;
                result.add(class_name);
            }
        }
        return result;
    }

    public static Set<Class<?>> getClassesFromClassPath() throws IOException, ClassNotFoundException {
        return ClassUtil.getClassesFromClassPath(ClassUtil::filterSkipStartWith);
    }

    public static Set<Class<?>> getClassesFromClassPath(Predicate<String> classNamesFilter) throws IOException, ClassNotFoundException {
        TreeSet classes_set = new TreeSet(new ClassComparator());
        String classpath = System.getProperty("java.class.path");
        StringTokenizer stok = new StringTokenizer(classpath, File.pathSeparator, false);
        while (stok.hasMoreTokens()) {
            Set<String> class_names;
            String path = stok.nextToken();
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                class_names = ClassUtil.getClassNamesFromDir(file);
                classes_set.addAll(ClassUtil.getClassesFromNames(class_names, classNamesFilter));
            }
            if (!file.isFile()) continue;
            class_names = ClassUtil.getClassNamesFromJar(file);
            classes_set.addAll(ClassUtil.getClassesFromNames(class_names, classNamesFilter));
        }
        return classes_set;
    }

    public static Set<Class<?>> getClassesFromNames(Set<String> names) throws ClassNotFoundException {
        return ClassUtil.getClassesFromNames(names, ClassUtil::filterSkipStartWith);
    }

    public static Set<Class<?>> getClassesFromNames(Set<String> names, Predicate<String> filter) throws ClassNotFoundException {
        TreeSet classes = new TreeSet(new ClassComparator());
        for (String name : names) {
            try {
                String test_str2;
                boolean skip_class = false;
                String[] stringArray = SKIP_CONTAINS;
                int n = stringArray.length;
                for (int i = 0; i < n && !(skip_class = name.contains(test_str2 = stringArray[i])); ++i) {
                }
                if (!filter.test(name)) {
                    skip_class = true;
                }
                for (String test_str2 : SKIP_WHITELIST) {
                    if (!name.startsWith(test_str2)) continue;
                    skip_class = false;
                    break;
                }
                if (skip_class) continue;
                Class<?> cls = Class.forName(name, false, ClassLoader.getSystemClassLoader());
                classes.add(cls);
            }
            catch (UnsupportedClassVersionError e) {
                log.log(System.Logger.Level.WARNING, "Class: " + name + " compiled using newer JDK version. Please upgrade your JDK!");
            }
            catch (SecurityException e) {
            }
            catch (NoClassDefFoundError e) {
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                System.out.println("Class name: " + name);
                e.printStackTrace();
                if (cause == null) continue;
                cause.printStackTrace();
            }
        }
        return classes;
    }

    public static <T extends Class> Set<T> getClassesImplementing(Collection<Class<?>> classes, T cls) {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        for (Class<?> c : classes) {
            int mod;
            if (!cls.isAssignableFrom(c) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
            classes_set.add(c);
        }
        return classes_set;
    }

    public static <T extends Class> Set<T> getClassesImplementing(T cls) throws IOException, ClassNotFoundException {
        return ClassUtil.getClassesImplementing(ClassUtil.getClassesFromClassPath(), cls);
    }

    public static Set<String> getFileListDeep(File path) {
        TreeSet<String> set = new TreeSet<String>();
        if (path.isDirectory()) {
            String[] files;
            for (String file : files = path.list()) {
                ClassUtil.walkInDirForFiles(path, file, set);
            }
        } else {
            set.add(path.toString());
        }
        return set;
    }

    public static <T> Set<T> getImplementations(Class<T> obj) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TreeSet<Object> result = new TreeSet<Object>(new ObjectComparator());
        for (Class<T> cls : ClassUtil.getClassesImplementing(obj)) {
            result.add(cls.newInstance());
        }
        return result;
    }

    public static void walkInDirForFiles(File base_dir, String path, Set<String> set) {
        File tmp_file = new File(base_dir, path);
        if (tmp_file.isDirectory()) {
            String[] files;
            for (String file : files = tmp_file.list()) {
                ClassUtil.walkInDirForFiles(base_dir, new File(path, file).toString(), set);
            }
        } else {
            set.add(path);
        }
    }

    public static boolean filterIncorrectMultiVersionClasses(String name) {
        if (name.startsWith(META_VERSION_PREFIX)) {
            int prefixLength = META_VERSION_PREFIX.length();
            String version = name.substring(prefixLength, name.indexOf(".", prefixLength));
            return Integer.parseInt(version) > RUNTIME_FEATURE_VERSION;
        }
        return false;
    }

    private static boolean filterSkipStartWith(String name) {
        for (String test_str : SKIP_STARTS) {
            if (!name.startsWith(test_str)) continue;
            return false;
        }
        return true;
    }
}

