/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.List;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class AbstractForm {
    protected static final System.Logger log = System.getLogger(AbstractForm.class.getName());
    protected String instruction;
    protected String title;
    protected String type;

    public AbstractForm(Element form) {
        this.type = form.getAttributeStaticStr("type");
        log.log(System.Logger.Level.TRACE, "Retriving Data Form type " + this.type);
        List children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if ("title".equals(sub.getName())) {
                    this.title = sub.getCData();
                    log.log(System.Logger.Level.TRACE, "read Data Form title [" + this.title + "]");
                    continue;
                }
                if (!"instructions".equals(sub.getName())) continue;
                this.instruction = sub.getCData();
                log.log(System.Logger.Level.TRACE, "read Data Form instruction [" + this.instruction + "]");
            }
        }
    }

    public AbstractForm(String type, String title, String instruction) {
        this.type = type;
        this.title = title;
        this.instruction = instruction;
    }

    public Element getElement() {
        Element form = new Element("x");
        form.setAttribute("xmlns", "jabber:x:data");
        if (this.type != null) {
            form.setAttribute("type", this.type);
        }
        if (this.title != null) {
            form.addChild((XMLNodeIfc)new Element("title", this.title));
        }
        if (this.instruction != null) {
            form.addChild((XMLNodeIfc)new Element("instructions", this.instruction));
        }
        return form;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeOrElse(String defValue) {
        if (this.type == null) {
            return defValue;
        }
        return this.type;
    }

    public boolean isType(String type) {
        return this.type != null && this.type.equals(type);
    }
}

