/*
 * Decompiled with CFR 0.152.
 */
package tigase.collections;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class CircularFifoQueue<E>
extends AbstractQueue<E> {
    private final Optional<Consumer<E>> consumer;
    private final Queue<E> queue;
    private int limit;

    public CircularFifoQueue(int maxEntries, Consumer<E> overflowConsumer) {
        this.limit = maxEntries;
        this.queue = new LinkedBlockingQueue();
        this.consumer = Optional.ofNullable(overflowConsumer);
    }

    @Override
    public boolean add(E e) {
        boolean result = this.queue.add(e);
        return result |= this.pruneQueue();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.queue.addAll(c);
        return result |= this.pruneQueue();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    public int limit() {
        return this.limit;
    }

    @Override
    public boolean offer(E element) {
        boolean result = this.queue.offer(element);
        return result |= this.pruneQueue();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    public boolean setLimit(int limit) {
        this.limit = limit;
        return this.pruneQueue();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    private boolean pruneQueue() {
        if (this.size() <= this.limit) {
            return false;
        }
        while (this.size() > this.limit) {
            Object tmp = this.queue.poll();
            this.consumer.ifPresent(c -> c.accept(tmp));
        }
        return true;
    }
}

