/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.ui.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CommandlineParameter {
    private final String defaultValue;
    private final String description;
    private final String fullName;
    private final boolean requireArguments;
    private final boolean required;
    private final boolean secret;
    private final List<String> selectionOptions;
    private final String singleLetter;
    private final Optional<Function<String, List<CommandlineParameter>>> valueDependentParametersProvider;
    private Class type;
    private String value;

    private CommandlineParameter(Builder builder) {
        this.singleLetter = builder.singleLetter;
        this.fullName = builder.fullName;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.secret = builder.secret;
        this.requireArguments = builder.requireArguments;
        this.required = builder.required;
        this.selectionOptions = builder.selectionOptions;
        this.type = builder.type;
        this.valueDependentParametersProvider = Optional.ofNullable(builder.valueDependentParametersProvider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandlineParameter that = (CommandlineParameter)o;
        return this.singleLetter != null && this.singleLetter.equals(that.singleLetter) || this.fullName != null && this.fullName.equals(that.fullName);
    }

    public Optional<String> getDefaultValue() {
        return null != this.defaultValue ? Optional.of(this.defaultValue) : Optional.empty();
    }

    public Optional<String> getDescription() {
        return null != this.description ? Optional.of(this.description) : Optional.empty();
    }

    public Optional<String> getFullName(boolean includeDash) {
        return null == this.fullName ? Optional.empty() : Optional.of((includeDash ? "--" : "") + this.fullName);
    }

    public Optional<String> getFullName() {
        return this.getFullName(false);
    }

    public Optional<List<String>> getSelectionOptions() {
        return null != this.selectionOptions && !this.selectionOptions.isEmpty() ? Optional.of(this.selectionOptions) : Optional.empty();
    }

    public Optional<String> getSingleLetter() {
        return this.getSingleLetter(false);
    }

    public Optional<String> getSingleLetter(boolean includeDash) {
        return null == this.singleLetter ? Optional.empty() : Optional.of((includeDash ? "-" : "") + this.singleLetter);
    }

    public Class getType() {
        return this.type;
    }

    public Optional<String> getValue() {
        return null == this.value ? Optional.empty() : Optional.of(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<CommandlineParameter> getValueDependentParameters() {
        if (this.valueDependentParametersProvider.isPresent() && this.getValue().isPresent()) {
            return this.valueDependentParametersProvider.get().apply(this.value);
        }
        return Collections.emptyList();
    }

    public boolean hasValueDependentParameters() {
        return this.valueDependentParametersProvider.isPresent();
    }

    public int hashCode() {
        int result = this.singleLetter != null ? this.singleLetter.hashCode() : 0;
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        return result;
    }

    public boolean isRequireArguments() {
        return this.requireArguments;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setValueFromDefault() {
        if (this.getDefaultValue().isPresent()) {
            this.value = this.getDefaultValue().get();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CommandlineParameter{");
        sb.append("singleLetter='").append(this.singleLetter).append('\'');
        sb.append(", fullName='").append(this.fullName).append('\'');
        sb.append(", defaultValue='").append(this.defaultValue).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", secret=").append(this.secret);
        sb.append(", requireArguments=").append(this.requireArguments);
        sb.append(", required=").append(this.required);
        sb.append(", selectionOptions=").append(this.selectionOptions);
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String toStringSimple() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("letter='").append(this.singleLetter).append('\'');
        sb.append(", name='").append(this.fullName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final String fullName;
        private final String singleLetter;
        private String defaultValue = null;
        private String description = null;
        private boolean requireArguments = true;
        private boolean required = false;
        private boolean secret = false;
        private List<String> selectionOptions = null;
        private Class type = String.class;
        private Function<String, List<CommandlineParameter>> valueDependentParametersProvider;

        public Builder(String singleLetter, String fullName) {
            if (null == singleLetter && null == fullName) {
                throw new IllegalArgumentException("Either single letter or full-length parameter is required");
            }
            this.singleLetter = singleLetter;
            this.fullName = fullName;
        }

        public CommandlineParameter build() {
            return new CommandlineParameter(this);
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder options(String ... options) {
            if (null == this.selectionOptions) {
                this.selectionOptions = new ArrayList<String>();
            }
            if (null != options && options.length > 0) {
                this.selectionOptions.addAll(Arrays.asList(options));
            }
            return this;
        }

        public Builder requireArguments(boolean required) {
            this.requireArguments = required;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder secret() {
            this.secret = true;
            return this;
        }

        public Builder type(Class type) {
            this.type = type;
            return this;
        }

        public Builder valueDependentParametersProvider(Function<String, List<CommandlineParameter>> provider) {
            this.valueDependentParametersProvider = provider;
            return this;
        }
    }
}

