/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.dns;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.dns.DNSEntry;

public interface DNSResolverIfc {
    public static final String TIGASE_PRIMARY_ADDRESS = "tigase-primary-address";
    public static final String TIGASE_SECONDARY_ADDRESS = "tigase-secondary-address";
    public static final System.Logger log = System.getLogger(DNSResolverIfc.class.getName());
    public static final Random rand = new Random();

    public String getDefaultHost();

    default public String[] getDefaultHosts() {
        return new String[]{this.getDefaultHost()};
    }

    default public String getSecondaryHost() {
        return this.getDefaultHost();
    }

    default public String getHostIP(String hostname) throws UnknownHostException {
        return this.getHostIPs(hostname)[0];
    }

    public String[] getHostIPs(String var1) throws UnknownHostException;

    default public DNSEntry[] getHostSRV_Entries(String hostname) throws UnknownHostException {
        String service = "_xmpp-server._tcp";
        int defPort = 5269;
        return this.getHostSRV_Entries(hostname, service, defPort);
    }

    default public DNSEntry[] getHostSRV_Entries(String hostname, String service, int defPort) throws UnknownHostException {
        String key = service + "." + hostname;
        String result_host = hostname;
        int port = defPort;
        int priority = 0;
        int weight = 0;
        long ttl = 3600000L;
        TreeSet<DNSEntry> entries = new TreeSet<DNSEntry>();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(5);
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(service + "." + hostname, new String[]{"SRV"});
            Attribute att = attrs.get("SRV");
            if (att != null && att.size() > 0) {
                for (int i = 0; i < att.size(); ++i) {
                    String[] dns_resp = att.get(i).toString().split(" ");
                    try {
                        priority = Integer.parseInt(dns_resp[0]);
                    }
                    catch (Exception e) {
                        priority = 0;
                    }
                    try {
                        weight = Integer.parseInt(dns_resp[1]);
                    }
                    catch (Exception e) {
                        weight = 0;
                    }
                    try {
                        port = Integer.parseInt(dns_resp[2]);
                    }
                    catch (Exception e) {
                        port = defPort;
                    }
                    result_host = dns_resp[3];
                    try {
                        String[] ip_addresses = this.getHostIPs(result_host);
                        entries.add(new DNSEntry(hostname, result_host, ip_addresses, port, ttl, priority, weight));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            } else {
                log.log(System.Logger.Level.TRACE, "Empty SRV DNS records set for domain: {0}", hostname);
            }
            ctx.close();
        }
        catch (NamingException e) {
            result_host = hostname;
            log.log(System.Logger.Level.TRACE, () -> "Problem getting SRV DNS records for domain: " + hostname + ", " + e.getMessage());
        }
        if (entries.isEmpty()) {
            String[] ip_address = this.getHostIPs(result_host);
            entries.add(new DNSEntry(hostname, ip_address, port));
        }
        log.log(System.Logger.Level.TRACE, () -> "Resolved DNS for : " + hostname + " to: " + String.valueOf(entries));
        return entries.toArray(new DNSEntry[0]);
    }

    default public DNSEntry getHostSRV_Entry(String hostname) throws UnknownHostException {
        String service = "_xmpp-server._tcp";
        int defPort = 5269;
        return this.getHostSRV_Entry(hostname, service, defPort);
    }

    default public DNSEntry getHostSRV_Entry(String hostname, String service, int defPort) throws UnknownHostException {
        Object[] entries = this.getHostSRV_Entries(hostname, service, defPort);
        if (entries == null || entries.length == 0) {
            return null;
        }
        int priority = Integer.MAX_VALUE;
        Object result = null;
        int start = rand.nextInt(entries.length);
        int idx = 0;
        for (int i = 0; i < entries.length; ++i) {
            idx = (i + start) % entries.length;
            if (entries[idx].getPriority() >= priority) continue;
            priority = ((DNSEntry)entries[idx]).getPriority();
            result = entries[idx];
        }
        if (result == null) {
            result = entries[0];
            log.log(System.Logger.Level.WARNING, "No result?? should not happen, an error in the code: {0}", Arrays.toString(entries));
        }
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            log.log(System.Logger.Level.TRACE, "Start idx: {0}, last idx: {1}, selected DNSEntry: {2}", start, idx, result);
        }
        return result;
    }

    default public String getHostSRV_IP(String hostname) throws UnknownHostException {
        DNSEntry entry = this.getHostSRV_Entry(hostname);
        return entry != null ? entry.getIp() : null;
    }
}

