/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    public static final EnumSet<FIELD> incrementableFields = EnumSet.of(FIELD.MAJOR, FIELD.MINOR, FIELD.BUGFIX, FIELD.BUILD, FIELD.TYPE_NUMBER);
    public static final Comparator<Version> VERSION_COMPARATOR = Comparator.comparingInt(Version::getMajor).thenComparingInt(Version::getMinor).thenComparingInt(Version::getBugfix).thenComparing(Version::getVersionType).thenComparingInt(Version::getTypeNumber).thenComparingInt(Version::getBuild);
    private static final System.Logger log = System.getLogger("tigase.util.updater.UpdatesChecker");
    private static final Pattern PATTERN = Pattern.compile("(.*?)-?((\\d{1,20}\\.){1,2}\\d{1,20})(-(SNAPSHOT|RC|BETA)(\\d*))?(-b(\\d{1,50})(/([0-9a-f]{4,16}))?)?", 2);
    public static final Version ZERO = Version.of("0.0.0-b0000");
    private final int bugfix;
    private final int build;
    private final String commit;
    private final String component;
    private final int major;
    private final int minor;
    private final int typeNumber;
    private final TYPE versionType;

    public static Version of(String str) throws IllegalArgumentException {
        int typeNumber;
        TYPE versionType;
        String commit;
        int build;
        int bugfix;
        int minor;
        int major;
        String component;
        block23: {
            component = null;
            major = 0;
            minor = 0;
            bugfix = 0;
            build = 0;
            commit = null;
            versionType = TYPE.FINAL;
            typeNumber = 0;
            Matcher matcher = PATTERN.matcher(str);
            if (matcher.find()) {
                String mainVersionPart = null;
                String buildStr = null;
                String typeNumberStr = null;
                switch (matcher.groupCount()) {
                    case 10: {
                        commit = matcher.group(10);
                    }
                    case 8: {
                        if (matcher.group(8) != null) {
                            buildStr = matcher.group(8);
                        }
                    }
                    case 6: {
                        if (matcher.group(6) != null && !matcher.group(6).trim().isEmpty()) {
                            typeNumberStr = matcher.group(6);
                        }
                    }
                    case 5: {
                        if (matcher.group(5) != null) {
                            versionType = TYPE.valueOf(matcher.group(5).toUpperCase());
                        }
                    }
                    case 2: {
                        mainVersionPart = matcher.group(2);
                    }
                    case 1: {
                        component = matcher.group(1);
                    }
                }
                try {
                    if (mainVersionPart == null) break block23;
                    String[] versionParts = mainVersionPart.split("\\.");
                    switch (versionParts.length) {
                        case 3: {
                            bugfix = Integer.parseInt(versionParts[2]);
                        }
                        case 2: {
                            minor = Integer.parseInt(versionParts[1]);
                        }
                        case 1: {
                            major = Integer.parseInt(versionParts[0]);
                        }
                    }
                    if (buildStr != null && !buildStr.trim().isEmpty()) {
                        build = Integer.valueOf(buildStr);
                    }
                    if (typeNumberStr != null && !typeNumberStr.trim().isEmpty()) {
                        typeNumber = Integer.valueOf(typeNumberStr);
                    }
                }
                catch (NumberFormatException e) {
                    log.log(System.Logger.Level.WARNING, "Can not detect the server version.... " + str);
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.WARNING, "Problem parsing server version.... " + str, (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("Wrong Version format provided");
            }
        }
        return new Version(component, versionType, major, minor, bugfix, build, typeNumber, commit);
    }

    private Version(Builder builder) {
        this.component = builder.component;
        this.versionType = builder.versionType;
        this.typeNumber = builder.typeNumber;
        this.major = builder.major;
        this.minor = builder.minor;
        this.bugfix = builder.bugfix;
        this.build = builder.build;
        this.commit = builder.commit;
    }

    private Version(String component, TYPE type, int major, int minor, int bugfix, int build, int typeNumber, String commit) {
        this.component = component;
        this.typeNumber = typeNumber;
        this.versionType = type;
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.build = build;
        this.commit = commit;
    }

    @Override
    public int compareTo(Version that) {
        return VERSION_COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.versionType != version.versionType) {
            return false;
        }
        if (this.typeNumber != version.typeNumber) {
            return false;
        }
        if (this.build != version.build) {
            return false;
        }
        return this.commit != null ? this.commit.equals(version.commit) : version.commit == null;
    }

    public Version getBaseVersion() {
        if (ZERO.equals(this)) {
            return ZERO;
        }
        return new Builder(this.major, this.minor, this.bugfix).build();
    }

    public int getBugfix() {
        return this.bugfix;
    }

    public int getBuild() {
        return this.build;
    }

    public String getCommit() {
        return this.commit;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public TYPE getVersionType() {
        return this.versionType;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.bugfix;
        result = 31 * result + this.versionType.hashCode();
        result = 31 * result + this.typeNumber;
        result = 31 * result + this.build;
        result = 31 * result + (this.commit != null ? this.commit.hashCode() : 0);
        return result;
    }

    public Version increment(FIELD field, int amount) throws IllegalArgumentException {
        if (incrementableFields.contains((Object)field)) {
            Builder builder = new Builder(this);
            switch (field.ordinal()) {
                case 1: {
                    builder.major += amount;
                    break;
                }
                case 2: {
                    builder.minor += amount;
                    break;
                }
                case 3: {
                    builder.bugfix += amount;
                    break;
                }
                case 5: {
                    builder.typeNumber += amount;
                    break;
                }
                case 6: {
                    builder.build += amount;
                }
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Only numeric fields can be incremented");
    }

    public boolean isZero() {
        return this.major == 0 && this.minor == 0 && this.bugfix == 0 && this.build == 0;
    }

    public String toString() {
        return String.format("%1$s.%2$s.%3$s%4$s%5$s%6$s", this.major, this.minor, this.bugfix, this.versionType != null ? this.versionType.getId() + String.valueOf(this.typeNumber > 0 ? Integer.valueOf(this.typeNumber) : "") : "", this.build > 0 ? "-b" + this.build : "", this.commit != null ? "/" + this.commit : "");
    }

    public String toString(int padding) {
        return String.format("%1$s.%2$s.%3$s%4$s%5$s%6$s", String.format("%0" + padding + "d", this.major), String.format("%0" + padding + "d", this.minor), String.format("%0" + padding + "d", this.bugfix), this.versionType != null ? this.versionType.getId() + String.valueOf(this.typeNumber > 0 ? Integer.valueOf(this.typeNumber) : "") : "", this.build > 0 ? "-b" + String.format("%0" + 3 * padding + "d", this.build) : "", this.commit != null ? "/" + this.commit : "");
    }

    public static enum TYPE {
        SNAPSHOT("-SNAPSHOT"),
        BETA("-BETA"),
        RC("-RC"),
        FINAL("");

        private String id;

        private TYPE(String s) {
            this.id = s;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Builder {
        private int bugfix = 0;
        private int build = 0;
        private String commit = null;
        private String component = null;
        private int major = 0;
        private int minor = 0;
        private int typeNumber = 0;
        private TYPE versionType = TYPE.FINAL;

        public Builder(int major, int minor, int bugfix) {
            this.major = major;
            this.minor = minor;
            this.bugfix = bugfix;
        }

        public Builder(Version version) {
            this.major = version.major;
            this.minor = version.minor;
            this.bugfix = version.bugfix;
            this.build = version.build;
            this.component = version.component;
            this.versionType = version.versionType;
            this.typeNumber = version.typeNumber;
            this.commit = version.commit;
        }

        public Version build() {
            return new Version(this);
        }

        public Builder setBuild(int build) {
            this.build = build;
            return this;
        }

        public Builder setCommit(String commit) {
            this.commit = commit;
            return this;
        }

        public Builder setVersionType(TYPE versionType) {
            this.versionType = versionType;
            return this;
        }
    }

    public static enum FIELD {
        COMPONENT,
        MAJOR,
        MINOR,
        BUGFIX,
        TYPE,
        TYPE_NUMBER,
        BUILD,
        COMMIT;

    }
}

