/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import tigase.form.Form;
import tigase.form.FormSignerException;
import tigase.form.SignatureCalculator;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class FormSignatureVerifier {
    private String oauthConsumerKey;
    private String oauthConsumerSecret;

    public FormSignatureVerifier(String oauthConsumerKey, String oauthConsumerSecret) {
        this.oauthConsumerKey = oauthConsumerKey;
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public long verify(JID to, Element form) throws FormSignerException {
        return this.verify(to, new Form(form), null);
    }

    public long verify(JID to, Element form, SignatureVerifyHandler handler) throws FormSignerException {
        return this.verify(to, new Form(form), handler);
    }

    public long verify(JID to, Form form) throws FormSignerException {
        return this.verify(to, form, null);
    }

    public long verify(JID to, Form form, SignatureVerifyHandler handler) throws FormSignerException {
        if (!this.isFormSigned(form)) {
            throw new FormSignerException("Form isn't signed.");
        }
        try {
            Long timestamp = form.getAsLong("oauth_timestamp");
            String fSignature = form.getAsString("oauth_signature");
            String fOauthSignatureMethod = form.getAsString("oauth_signature_method");
            String fOauthToken = form.getAsString("oauth_token");
            String fOauthTokenSecret = form.getAsString("oauth_token_secret");
            String fOauthConsumerKey = form.getAsString("oauth_consumer_key");
            if (!fOauthConsumerKey.equals(this.oauthConsumerKey)) {
                throw new FormSignerException("Unrecognized oauth_consumer_key.");
            }
            SignatureCalculator calculator = new SignatureCalculator(fOauthToken, fOauthTokenSecret, this.oauthConsumerKey, this.oauthConsumerSecret);
            if (!calculator.isMethodSupported(fOauthSignatureMethod)) {
                throw new FormSignerException("Signature method " + fOauthSignatureMethod + " isn't supported.");
            }
            String calculatedSignature = calculator.calculateSignature(to, form);
            if (!calculatedSignature.equals(fSignature)) {
                throw new FormSignerException("Invalid signature.");
            }
            if (handler != null) {
                handler.onFormVerify(to, form, calculator);
            }
            return timestamp;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new FormSignerException("Cannot validate signature of Form", e);
        }
    }

    protected boolean isFormSigned(Form form) {
        String tp = form.getAsString("FORM_TYPE");
        if (tp == null || !tp.equals("urn:xmpp:xdata:signature:oauth1")) {
            return false;
        }
        return form.get("oauth_timestamp") != null && form.get("oauth_signature") != null;
    }

    public static interface SignatureVerifyHandler {
        public void onFormVerify(JID var1, Form var2, SignatureCalculator var3) throws FormSignerException;
    }
}

