/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.LinkedList;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class Field
implements Comparable<Field> {
    private String description;
    private String label;
    private String[] optionLabels;
    private String[] optionValues;
    private boolean required;
    private FieldType type;
    private String[] values;
    private String var;

    public static Field fieldBoolean(String var, Boolean value, String label) {
        Field field = new Field(FieldType.bool);
        field.label = label;
        field.var = var;
        if (value != null && value.booleanValue()) {
            field.values = new String[]{"1"};
        } else if (value != null && !value.booleanValue()) {
            field.values = new String[]{"0"};
        }
        return field;
    }

    public static Field fieldFixed(String value) {
        Field field = new Field(FieldType.fixed);
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldHidden(String var, String value) {
        Field field = new Field(FieldType.hidden, var);
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldJidMulti(String var, String[] values, String label) {
        Field field = new Field(FieldType.jid_multi, var);
        field.label = label;
        field.values = values;
        return field;
    }

    public static Field fieldJidSingle(String var, String value, String label) {
        Field field = new Field(FieldType.jid_single, var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldListMulti(String var, String[] values, String label, String[] optionsLabel, String[] optionsValue) {
        if (optionsLabel != null && optionsLabel.length != optionsValue.length) {
            throw new RuntimeException("Invalid optionsLabel and optinsValue length");
        }
        Field field = new Field(FieldType.list_multi, var);
        field.label = label;
        field.values = values;
        field.optionLabels = optionsLabel;
        field.optionValues = optionsValue;
        return field;
    }

    public static Field fieldListSingle(String var, String value, String label, String[] optionsLabel, String[] optionsValue) {
        if (optionsLabel != null && optionsLabel.length != optionsValue.length) {
            throw new RuntimeException("Invalid optionsLabel and optinsValue length");
        }
        Field field = new Field(FieldType.list_single, var);
        field.label = label;
        field.values = new String[]{value};
        field.optionLabels = optionsLabel;
        field.optionValues = optionsValue;
        return field;
    }

    public static Field fieldTextMulti(String var, String value, String label) {
        Field field = new Field(FieldType.text_multi, var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldTextMulti(String var, String[] values, String label) {
        Field field = new Field(FieldType.text_multi, var);
        field.label = label;
        field.values = values;
        return field;
    }

    public static Field fieldTextPrivate(String var, String value, String label) {
        Field field = new Field(FieldType.text_private, var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Field fieldTextSingle(String var, String value, String label) {
        Field field = new Field(FieldType.text_single, var);
        field.label = label;
        field.values = new String[]{value};
        return field;
    }

    public static Boolean getAsBoolean(Field f) {
        if (f != null) {
            String v = f.getValue();
            if (v == null) {
                return null;
            }
            if ("1".equals(v) || "true".equals(v)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static void main(String[] args) {
        Element field = new Element("field", new String[]{"var", "type"}, new String[]{"pubsub#presence_based_delivery", "boolean"});
        field.addChild((XMLNodeIfc)new Element("value", "true"));
        Field f = new Field(field);
        System.out.println(f);
        System.out.println(Field.getAsBoolean(f));
    }

    public Field(Element fieldElement) {
        this.var = fieldElement.getAttributeStaticStr("var");
        String $type = fieldElement.getAttributeStaticStr("type");
        this.type = $type == null ? FieldType.text_single : FieldType.getFieldTypeByName($type);
        this.label = fieldElement.getAttributeStaticStr("label");
        Element d = fieldElement.getChild("desc");
        if (d != null) {
            this.description = d.getCData();
        }
        this.required = fieldElement.getChild("required") != null;
        LinkedList<String> valueList = new LinkedList<String>();
        LinkedList<String> optionsLabelList = new LinkedList<String>();
        LinkedList<String> optionsValueList = new LinkedList<String>();
        if (fieldElement.getChildren() != null) {
            for (Element element : fieldElement.getChildren()) {
                String v;
                if ("value".equals(element.getName())) {
                    v = element.getCData();
                    if (v == null) continue;
                    valueList.add(v);
                    continue;
                }
                if (!"option".equals(element.getName())) continue;
                optionsLabelList.add(element.getAttributeStaticStr("label"));
                v = element.getChild("value");
                optionsValueList.add(v.getCData());
            }
        }
        this.values = valueList.toArray(new String[0]);
        this.optionLabels = optionsLabelList.toArray(new String[0]);
        this.optionValues = optionsValueList.toArray(new String[0]);
    }

    private Field(FieldType type) {
        this.type = type;
    }

    private Field(FieldType type, String var) {
        this.type = type;
        this.var = var;
    }

    @Override
    public int compareTo(Field o) {
        return this.var.compareTo(o.getVar());
    }

    public Field cloneShalow() {
        Field field = new Field(this.type, this.var);
        field.setLabel(this.label);
        return field;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Element getElement() {
        return this.getElement(true, true);
    }

    public Element getElement(boolean type, boolean label) {
        Element field = new Element("field");
        if (this.var != null) {
            field.setAttribute("var", this.var);
        }
        if (type && this.type != null) {
            field.setAttribute("type", this.type.toString());
        }
        if (label && this.label != null) {
            field.setAttribute("label", this.label);
        }
        if (this.description != null) {
            field.addChild((XMLNodeIfc)new Element("desc", this.description));
        }
        if (this.required) {
            field.addChild((XMLNodeIfc)new Element("required"));
        }
        if (this.values != null) {
            for (String value : this.values) {
                field.addChild((XMLNodeIfc)new Element("value", value));
            }
        }
        if (this.optionValues != null) {
            for (int i = 0; i < this.optionValues.length; ++i) {
                Element option = new Element("option");
                if (this.optionLabels != null && i < this.optionLabels.length) {
                    option.setAttribute("label", this.optionLabels[i]);
                }
                Element vo = new Element("value");
                if (this.optionValues[i] != null && !"".equals(this.optionValues[i])) {
                    vo.setCData(this.optionValues[i]);
                }
                option.addChild((XMLNodeIfc)vo);
                field.addChild((XMLNodeIfc)option);
            }
        }
        return field;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public String[] getOptionValues() {
        return this.optionValues;
    }

    public void setOptionValues(String[] optionValues) {
        this.optionValues = optionValues;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public String getValue() {
        if (this.values != null && this.values.length > 0) {
            return this.values[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values == null) {
            sb.append("*null*");
        } else {
            for (String c : this.values) {
                sb.append("[");
                sb.append(c);
                sb.append("] ");
            }
        }
        return this.var + " = " + sb.toString();
    }

    public static enum FieldType {
        bool("boolean"),
        fixed("fixed"),
        hidden("hidden"),
        jid_single("jid-single"),
        jid_multi("jid-multi"),
        list_multi("list-multi"),
        list_single("list-single"),
        text_multi("text-multi"),
        text_private("text-private"),
        text_single("text-single");

        private String desc;

        public static FieldType getFieldTypeByName(String name) {
            if ("boolean".equals(name)) {
                return bool;
            }
            return FieldType.valueOf(name.replace("-", "_"));
        }

        private FieldType(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }
    }
}

