/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateGenerator;

public class KeytoolCertificateGenerator
implements CertificateGenerator {
    private static final System.Logger log = System.getLogger(KeytoolCertificateGenerator.class.getCanonicalName());

    private static void appendName(StringBuilder sb, String prefix, String value) {
        log.log(System.Logger.Level.DEBUG, "appending value: {0} with prefix: {1} to sb: {2}", value, prefix, sb.toString());
        if (value != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(prefix).append('=').append(value);
        }
    }

    @Override
    public boolean canGenerateWildcardSAN() {
        return Runtime.version().feature() >= 17;
    }

    @Override
    public X509Certificate generateSelfSignedCertificate(String email, String domain, String organizationUnit, String organization, String city, String state, String country, KeyPair keyPair) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new UnsupportedOperationException("Generating self-signed certificate only is not supported by this implementaiton");
    }

    @Override
    public CertificateEntry generateSelfSignedCertificateEntry(String email, String domain, String organizationUnit, String organization, String city, String state, String country, KeyPair keyPair, boolean generateWildcardCnAlt) throws GeneralSecurityException, IOException {
        UUID uuid = UUID.randomUUID();
        String password = "123456";
        if (Files.notExists(Paths.get("certs", new String[0]), new LinkOption[0])) {
            Files.createDirectory(Paths.get("certs", new String[0]), new FileAttribute[0]);
        }
        Path file = Paths.get("certs", domain + "_" + String.valueOf(uuid) + ".jks");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (file.toFile().exists()) {
            keyStore.load(new FileInputStream(file.toFile()), "123456".toCharArray());
            if (keyStore.containsAlias(domain)) {
                keyStore.deleteEntry(domain);
                keyStore.store(new FileOutputStream(file.toFile()), "123456".toCharArray());
            }
        }
        ArrayList<String> commandParameters = new ArrayList<String>(List.of("keytool", "-genkey"));
        commandParameters.addAll(List.of("-alias", domain));
        commandParameters.addAll(List.of("-keyalg", "RSA"));
        commandParameters.addAll(List.of("-keysize", "2048"));
        commandParameters.addAll(List.of("-sigalg", "SHA256withRSA"));
        commandParameters.addAll(List.of("-storetype", "JKS"));
        commandParameters.addAll(List.of("-keystore", file.toString()));
        commandParameters.addAll(List.of("-storepass", "123456"));
        commandParameters.addAll(List.of("-keypass", "123456"));
        commandParameters.addAll(List.of("-dname", this.getDomainName(email, domain, organizationUnit, organization, city, state, country)));
        commandParameters.addAll(List.of("-validity", "365"));
        commandParameters.addAll(List.of("-deststoretype", "pkcs12"));
        commandParameters.addAll(List.of("-storetype", "JKS"));
        if (generateWildcardCnAlt && this.canGenerateWildcardSAN() && !this.isWildcardDomain(domain)) {
            commandParameters.addAll(this.getSAN(domain));
        }
        ProcessBuilder keytool = new ProcessBuilder(new String[0]).command(commandParameters);
        Process process = keytool.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Keytool execution error");
        }
        log.log(System.Logger.Level.TRACE, () -> "Generating certificate using `keytool` using command: " + String.valueOf(process.info()) + ", parameters: " + String.valueOf(commandParameters));
        if (process.exitValue() > 0) {
            String processError = new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().collect(Collectors.joining(" \\ "));
            String processOutput = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining(" \\ "));
            log.log(System.Logger.Level.WARNING, "Error generating certificate, error output: " + processError + ", normal output: " + processOutput + ", commandline parameters: " + String.valueOf(commandParameters));
            throw new IOException("Keytool execution error: '" + processError + "', output: '" + processOutput + "', commandline parameters: " + String.valueOf(commandParameters));
        }
        keyStore.load(new FileInputStream(file.toFile()), "123456".toCharArray());
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(domain, new KeyStore.PasswordProtection("123456".toCharArray()));
        Certificate[] chain = keyStore.getCertificateChain(domain);
        PrivateKey privateKey = pkEntry.getPrivateKey();
        CertificateEntry certificateEntry = new CertificateEntry(chain, privateKey);
        Files.deleteIfExists(file);
        return certificateEntry;
    }

    private boolean isWildcardDomain(String domain) {
        return domain.startsWith("*.");
    }

    private String getDomainName(String email, String domain, String organizationUnit, String organization, String city, String state, String country) {
        return "CN=" + domain + ", OU=" + organizationUnit + ", O=" + organization + ", L=" + city + ", ST=" + state + ", C=" + country + ", EMAILADDRESS=" + email;
    }

    private List<String> getSAN(String domain) {
        try {
            InetAddress address = InetAddress.getByName(domain);
            if (address != null && domain.equals(address.getHostAddress())) {
                return List.of("-ext", "SAN=dns:" + domain);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return List.of("-ext", "SAN=dns:*." + domain);
    }
}

