/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import tigase.cert.CertificateUtil;

public class CertificateEntry {
    private Certificate[] chain = null;
    private PrivateKey privateKey = null;
    private KeyPair keyPair = null;
    private String domain = null;
    private Set<String> allDomains = new HashSet<String>();
    private boolean selfSigned = false;

    public CertificateEntry() {
    }

    public CertificateEntry(Certificate[] chain, KeyPair keyPair) {
        this.chain = chain;
        this.keyPair = keyPair;
        this.privateKey = keyPair.getPrivate();
        this.updateChain();
    }

    public CertificateEntry(Certificate[] chain, PrivateKey privateKey) {
        this.chain = chain;
        this.privateKey = privateKey;
        this.updateChain();
        this.updateKeyPair();
    }

    public Certificate[] getCertChain() {
        return this.chain;
    }

    public Certificate[] getCertChain(boolean withoutRoot) {
        if (withoutRoot) {
            return CertificateUtil.removeRootCACertificate(this.chain);
        }
        return this.chain;
    }

    public void setCertChain(Certificate[] chain) {
        this.chain = chain;
        this.updateChain();
        this.updateKeyPair();
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.updateKeyPair();
    }

    public String getDomain() {
        return this.domain;
    }

    public Set<String> getAllDomains() {
        return this.allDomains;
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public boolean isValid() {
        if (this.chain == null || this.chain.length == 0) {
            return false;
        }
        if (this.chain[0] instanceof X509Certificate) {
            return !CertificateUtil.isExpired((X509Certificate)this.chain[0]);
        }
        return true;
    }

    private void updateChain() {
        this.allDomains.clear();
        this.domain = null;
        this.selfSigned = false;
        if (this.chain != null) {
            this.chain = CertificateUtil.sort(this.chain);
            if (this.chain[0] instanceof X509Certificate) {
                this.selfSigned = CertificateUtil.isSelfSigned((X509Certificate)this.chain[0]);
                this.allDomains.addAll(CertificateUtil.getCertAltCName((X509Certificate)this.chain[0]));
                this.domain = CertificateUtil.getCertCName((X509Certificate)this.chain[0]);
                if (this.domain != null) {
                    this.allDomains.add(this.domain);
                }
            }
        }
    }

    private void updateKeyPair() {
        if (this.chain != null && this.chain.length > 0 && this.privateKey != null) {
            this.keyPair = new KeyPair(this.chain[0].getPublicKey(), this.privateKey);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean basic) {
        StringBuilder sb = new StringBuilder(4096);
        for (Certificate cert : this.chain) {
            if (basic) {
                CertificateUtil.getCertificateBasicInfo(sb, cert);
                continue;
            }
            sb.append(cert.toString());
        }
        return "Alias: " + this.domain + ", alternative domains: " + String.valueOf(this.allDomains) + ", Private key: " + (this.privateKey != null ? "present" : "MISSING!!! \n\n\n") + "\n" + String.valueOf(sb);
    }

    public Optional<KeyPair> getKeyPair() {
        return Optional.ofNullable(this.keyPair);
    }

    public Optional<Certificate> getCertificate() {
        return this.chain != null && this.chain.length > 0 ? Optional.of(this.chain[0]) : Optional.empty();
    }
}

