/*
 * Tigase Utils - Utilities module
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
/* This file is automatically generated.  DO NOT EDIT!
   Instead, edit GenerateNFKC.java and re-run.  */

package gnu.inet.encoding;

/**
 * Auto-generated class containing Unicode NFKC tables.
 */
public class Composition
{
  public final static char[][] multiFirst = new char[][] {
    { '\u00C0', '\u00C1', '\u00C2', '\u00C3', '\u0100', '\u0102', '\u0226', '\u00C4', '\u1EA2', '\u00C5', '\u01CD', '\u0200', '\u0202', '\u1EA0', '\u1E00', '\u0104', },
    {        0,        0,        0,        0,        0,        0, '\u1E02',        0,        0,        0,        0,        0,        0, '\u1E04',        0,        0, '\u1E06', },
    {        0, '\u0106', '\u0108',        0,        0,        0, '\u010A',        0,        0,        0, '\u010C',        0,        0,        0,        0,        0,        0, '\u00C7', },
    {        0,        0,        0,        0,        0,        0, '\u1E0A',        0,        0,        0, '\u010E',        0,        0, '\u1E0C',        0,        0, '\u1E0E', '\u1E10', '\u1E12', },
    { '\u00C8', '\u00C9', '\u00CA', '\u1EBC', '\u0112', '\u0114', '\u0116', '\u00CB', '\u1EBA',        0, '\u011A', '\u0204', '\u0206', '\u1EB8',        0, '\u0118',        0, '\u0228', '\u1E18', '\u1E1A', },
    {        0, '\u01F4', '\u011C',        0, '\u1E20', '\u011E', '\u0120',        0,        0,        0, '\u01E6',        0,        0,        0,        0,        0,        0, '\u0122', },
    {        0,        0, '\u0124',        0,        0,        0, '\u1E22', '\u1E26',        0,        0, '\u021E',        0,        0, '\u1E24',        0,        0,        0, '\u1E28',        0,        0, '\u1E2A', },
    { '\u00CC', '\u00CD', '\u00CE', '\u0128', '\u012A', '\u012C', '\u0130', '\u00CF', '\u1EC8',        0, '\u01CF', '\u0208', '\u020A', '\u1ECA',        0, '\u012E',        0,        0,        0, '\u1E2C', },
    {        0, '\u1E30',        0,        0,        0,        0,        0,        0,        0,        0, '\u01E8',        0,        0, '\u1E32',        0,        0, '\u1E34', '\u0136', },
    {        0, '\u0139',        0,        0,        0,        0,        0,        0,        0,        0, '\u013D',        0,        0, '\u1E36',        0,        0, '\u1E3A', '\u013B', '\u1E3C', },
    {        0, '\u1E3E',        0,        0,        0,        0, '\u1E40',        0,        0,        0,        0,        0,        0, '\u1E42', },
    { '\u01F8', '\u0143',        0, '\u00D1',        0,        0, '\u1E44',        0,        0,        0, '\u0147',        0,        0, '\u1E46',        0,        0, '\u1E48', '\u0145', '\u1E4A', },
    { '\u00D2', '\u00D3', '\u00D4', '\u00D5', '\u014C', '\u014E', '\u022E', '\u00D6', '\u1ECE',        0, '\u01D1', '\u020C', '\u020E', '\u1ECC',        0, '\u01EA',        0,        0,        0,        0,        0, '\u0150', '\u01A0', },
    {        0, '\u1E54',        0,        0,        0,        0, '\u1E56', },
    {        0, '\u0154',        0,        0,        0,        0, '\u1E58',        0,        0,        0, '\u0158', '\u0210', '\u0212', '\u1E5A',        0,        0, '\u1E5E', '\u0156', },
    {        0, '\u015A', '\u015C',        0,        0,        0, '\u1E60',        0,        0,        0, '\u0160',        0,        0, '\u1E62',        0,        0,        0, '\u015E',        0,        0,        0,        0,        0, '\u0218', },
    {        0,        0,        0,        0,        0,        0, '\u1E6A',        0,        0,        0, '\u0164',        0,        0, '\u1E6C',        0,        0, '\u1E6E', '\u0162', '\u1E70',        0,        0,        0,        0, '\u021A', },
    { '\u00D9', '\u00DA', '\u00DB', '\u0168', '\u016A', '\u016C',        0, '\u00DC', '\u1EE6', '\u016E', '\u01D3', '\u0214', '\u0216', '\u1EE4',        0, '\u0172',        0,        0, '\u1E76', '\u1E74',        0, '\u0170', '\u01AF',        0, '\u1E72', },
    {        0,        0,        0, '\u1E7C',        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1E7E', },
    { '\u1E80', '\u1E82', '\u0174',        0,        0,        0, '\u1E86', '\u1E84',        0,        0,        0,        0,        0, '\u1E88', },
    {        0,        0,        0,        0,        0,        0, '\u1E8A', '\u1E8C', },
    { '\u1EF2', '\u00DD', '\u0176', '\u1EF8', '\u0232',        0, '\u1E8E', '\u0178', '\u1EF6',        0,        0,        0,        0, '\u1EF4', },
    {        0, '\u0179', '\u1E90',        0,        0,        0, '\u017B',        0,        0,        0, '\u017D',        0,        0, '\u1E92',        0,        0, '\u1E94', },
    { '\u00E0', '\u00E1', '\u00E2', '\u00E3', '\u0101', '\u0103', '\u0227', '\u00E4', '\u1EA3', '\u00E5', '\u01CE', '\u0201', '\u0203', '\u1EA1', '\u1E01', '\u0105', },
    {        0,        0,        0,        0,        0,        0, '\u1E03',        0,        0,        0,        0,        0,        0, '\u1E05',        0,        0, '\u1E07', },
    {        0, '\u0107', '\u0109',        0,        0,        0, '\u010B',        0,        0,        0, '\u010D',        0,        0,        0,        0,        0,        0, '\u00E7', },
    {        0,        0,        0,        0,        0,        0, '\u1E0B',        0,        0,        0, '\u010F',        0,        0, '\u1E0D',        0,        0, '\u1E0F', '\u1E11', '\u1E13', },
    { '\u00E8', '\u00E9', '\u00EA', '\u1EBD', '\u0113', '\u0115', '\u0117', '\u00EB', '\u1EBB',        0, '\u011B', '\u0205', '\u0207', '\u1EB9',        0, '\u0119',        0, '\u0229', '\u1E19', '\u1E1B', },
    {        0, '\u01F5', '\u011D',        0, '\u1E21', '\u011F', '\u0121',        0,        0,        0, '\u01E7',        0,        0,        0,        0,        0,        0, '\u0123', },
    {        0,        0, '\u0125',        0,        0,        0, '\u1E23', '\u1E27',        0,        0, '\u021F',        0,        0, '\u1E25',        0,        0, '\u1E96', '\u1E29',        0,        0, '\u1E2B', },
    { '\u00EC', '\u00ED', '\u00EE', '\u0129', '\u012B', '\u012D',        0, '\u00EF', '\u1EC9',        0, '\u01D0', '\u0209', '\u020B', '\u1ECB',        0, '\u012F',        0,        0,        0, '\u1E2D', },
    {        0,        0, '\u0135',        0,        0,        0,        0,        0,        0,        0, '\u01F0', },
    {        0, '\u1E31',        0,        0,        0,        0,        0,        0,        0,        0, '\u01E9',        0,        0, '\u1E33',        0,        0, '\u1E35', '\u0137', },
    {        0, '\u013A',        0,        0,        0,        0,        0,        0,        0,        0, '\u013E',        0,        0, '\u1E37',        0,        0, '\u1E3B', '\u013C', '\u1E3D', },
    {        0, '\u1E3F',        0,        0,        0,        0, '\u1E41',        0,        0,        0,        0,        0,        0, '\u1E43', },
    { '\u01F9', '\u0144',        0, '\u00F1',        0,        0, '\u1E45',        0,        0,        0, '\u0148',        0,        0, '\u1E47',        0,        0, '\u1E49', '\u0146', '\u1E4B', },
    { '\u00F2', '\u00F3', '\u00F4', '\u00F5', '\u014D', '\u014F', '\u022F', '\u00F6', '\u1ECF',        0, '\u01D2', '\u020D', '\u020F', '\u1ECD',        0, '\u01EB',        0,        0,        0,        0,        0, '\u0151', '\u01A1', },
    {        0, '\u1E55',        0,        0,        0,        0, '\u1E57', },
    {        0, '\u0155',        0,        0,        0,        0, '\u1E59',        0,        0,        0, '\u0159', '\u0211', '\u0213', '\u1E5B',        0,        0, '\u1E5F', '\u0157', },
    {        0, '\u015B', '\u015D',        0,        0,        0, '\u1E61',        0,        0,        0, '\u0161',        0,        0, '\u1E63',        0,        0,        0, '\u015F',        0,        0,        0,        0,        0, '\u0219', },
    {        0,        0,        0,        0,        0,        0, '\u1E6B', '\u1E97',        0,        0, '\u0165',        0,        0, '\u1E6D',        0,        0, '\u1E6F', '\u0163', '\u1E71',        0,        0,        0,        0, '\u021B', },
    { '\u00F9', '\u00FA', '\u00FB', '\u0169', '\u016B', '\u016D',        0, '\u00FC', '\u1EE7', '\u016F', '\u01D4', '\u0215', '\u0217', '\u1EE5',        0, '\u0173',        0,        0, '\u1E77', '\u1E75',        0, '\u0171', '\u01B0',        0, '\u1E73', },
    {        0,        0,        0, '\u1E7D',        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1E7F', },
    { '\u1E81', '\u1E83', '\u0175',        0,        0,        0, '\u1E87', '\u1E85',        0, '\u1E98',        0,        0,        0, '\u1E89', },
    {        0,        0,        0,        0,        0,        0, '\u1E8B', '\u1E8D', },
    { '\u1EF3', '\u00FD', '\u0177', '\u1EF9', '\u0233',        0, '\u1E8F', '\u00FF', '\u1EF7', '\u1E99',        0,        0,        0, '\u1EF5', },
    {        0, '\u017A', '\u1E91',        0,        0,        0, '\u017C',        0,        0,        0, '\u017E',        0,        0, '\u1E93',        0,        0, '\u1E95', },
    { '\u1FED', '\u0385',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FC1', },
    { '\u1EA6', '\u1EA4',        0, '\u1EAA',        0,        0,        0,        0, '\u1EA8', },
    {        0, '\u01FC',        0,        0, '\u01E2', },
    { '\u1EC0', '\u1EBE',        0, '\u1EC4',        0,        0,        0,        0, '\u1EC2', },
    { '\u1ED2', '\u1ED0',        0, '\u1ED6',        0,        0,        0,        0, '\u1ED4', },
    {        0, '\u1E4C',        0,        0, '\u022C',        0,        0, '\u1E4E', },
    { '\u01DB', '\u01D7',        0,        0, '\u01D5',        0,        0,        0,        0,        0, '\u01D9', },
    { '\u1EA7', '\u1EA5',        0, '\u1EAB',        0,        0,        0,        0, '\u1EA9', },
    {        0, '\u01FD',        0,        0, '\u01E3', },
    { '\u1EC1', '\u1EBF',        0, '\u1EC5',        0,        0,        0,        0, '\u1EC3', },
    { '\u1ED3', '\u1ED1',        0, '\u1ED7',        0,        0,        0,        0, '\u1ED5', },
    {        0, '\u1E4D',        0,        0, '\u022D',        0,        0, '\u1E4F', },
    { '\u01DC', '\u01D8',        0,        0, '\u01D6',        0,        0,        0,        0,        0, '\u01DA', },
    { '\u1EB0', '\u1EAE',        0, '\u1EB4',        0,        0,        0,        0, '\u1EB2', },
    { '\u1EB1', '\u1EAF',        0, '\u1EB5',        0,        0,        0,        0, '\u1EB3', },
    { '\u1E14', '\u1E16', },
    { '\u1E15', '\u1E17', },
    { '\u1E50', '\u1E52', },
    { '\u1E51', '\u1E53', },
    { '\u1EDC', '\u1EDA',        0, '\u1EE0',        0,        0,        0,        0, '\u1EDE',        0,        0,        0,        0, '\u1EE2', },
    { '\u1EDD', '\u1EDB',        0, '\u1EE1',        0,        0,        0,        0, '\u1EDF',        0,        0,        0,        0, '\u1EE3', },
    { '\u1EEA', '\u1EE8',        0, '\u1EEE',        0,        0,        0,        0, '\u1EEC',        0,        0,        0,        0, '\u1EF0', },
    { '\u1EEB', '\u1EE9',        0, '\u1EEF',        0,        0,        0,        0, '\u1EED',        0,        0,        0,        0, '\u1EF1', },
    { '\u1FBA', '\u0386',        0,        0, '\u1FB9', '\u1FB8',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F08', '\u1F09', '\u1FBC', },
    { '\u1FC8', '\u0388',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F18', '\u1F19', },
    { '\u1FCA', '\u0389',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F28', '\u1F29', '\u1FCC', },
    { '\u1FDA', '\u038A',        0,        0, '\u1FD9', '\u1FD8',        0, '\u03AA',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F38', '\u1F39', },
    { '\u1FF8', '\u038C',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F48', '\u1F49', },
    { '\u1FEA', '\u038E',        0,        0, '\u1FE9', '\u1FE8',        0, '\u03AB',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F59', },
    { '\u1FFA', '\u038F',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F68', '\u1F69', '\u1FFC', },
    { '\u1F70', '\u03AC',        0,        0, '\u1FB1', '\u1FB0',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FB6', '\u1F00', '\u1F01', '\u1FB3', },
    { '\u1F72', '\u03AD',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F10', '\u1F11', },
    { '\u1F74', '\u03AE',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FC6', '\u1F20', '\u1F21', '\u1FC3', },
    { '\u1F76', '\u03AF',        0,        0, '\u1FD1', '\u1FD0',        0, '\u03CA',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FD6', '\u1F30', '\u1F31', },
    { '\u1F78', '\u03CC',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F40', '\u1F41', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FE4', '\u1FE5', },
    { '\u1F7A', '\u03CD',        0,        0, '\u1FE1', '\u1FE0',        0, '\u03CB',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FE6', '\u1F50', '\u1F51', },
    { '\u1F7C', '\u03CE',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FF6', '\u1F60', '\u1F61', '\u1FF3', },
    { '\u1FD2', '\u0390',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FD7', },
    { '\u1FE2', '\u03B0',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FE7', },
    {        0, '\u03D3',        0,        0,        0,        0,        0, '\u03D4', },
    {        0,        0,        0,        0,        0, '\u04D0',        0, '\u04D2', },
    { '\u0400',        0,        0,        0,        0, '\u04D6',        0, '\u0401', },
    {        0,        0,        0,        0,        0, '\u04C1',        0, '\u04DC', },
    { '\u040D',        0,        0,        0, '\u04E2', '\u0419',        0, '\u04E4', },
    {        0,        0,        0,        0, '\u04EE', '\u040E',        0, '\u04F0',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u04F2', },
    {        0,        0,        0,        0,        0, '\u04D1',        0, '\u04D3', },
    { '\u0450',        0,        0,        0,        0, '\u04D7',        0, '\u0451', },
    {        0,        0,        0,        0,        0, '\u04C2',        0, '\u04DD', },
    { '\u045D',        0,        0,        0, '\u04E3', '\u0439',        0, '\u04E5', },
    {        0,        0,        0,        0, '\u04EF', '\u045E',        0, '\u04F1',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u04F3', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u0623', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u0BCA', '\u0BCC', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u0CC7', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u0D4A', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u0DDA', },
    {        0,        0, '\u1EAC',        0,        0, '\u1EB6', },
    {        0,        0, '\u1EAD',        0,        0, '\u1EB7', },
    { '\u1F02', '\u1F04',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F06',        0,        0, '\u1F80', },
    { '\u1F03', '\u1F05',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F07',        0,        0, '\u1F81', },
    { '\u1F0A', '\u1F0C',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F0E',        0,        0, '\u1F88', },
    { '\u1F0B', '\u1F0D',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F0F',        0,        0, '\u1F89', },
    { '\u1F12', '\u1F14', },
    { '\u1F13', '\u1F15', },
    { '\u1F1A', '\u1F1C', },
    { '\u1F1B', '\u1F1D', },
    { '\u1F22', '\u1F24',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F26',        0,        0, '\u1F90', },
    { '\u1F23', '\u1F25',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F27',        0,        0, '\u1F91', },
    { '\u1F2A', '\u1F2C',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F2E',        0,        0, '\u1F98', },
    { '\u1F2B', '\u1F2D',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F2F',        0,        0, '\u1F99', },
    { '\u1F32', '\u1F34',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F36', },
    { '\u1F33', '\u1F35',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F37', },
    { '\u1F3A', '\u1F3C',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F3E', },
    { '\u1F3B', '\u1F3D',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F3F', },
    { '\u1F42', '\u1F44', },
    { '\u1F43', '\u1F45', },
    { '\u1F4A', '\u1F4C', },
    { '\u1F4B', '\u1F4D', },
    { '\u1F52', '\u1F54',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F56', },
    { '\u1F53', '\u1F55',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F57', },
    { '\u1F5B', '\u1F5D',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F5F', },
    { '\u1F62', '\u1F64',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F66',        0,        0, '\u1FA0', },
    { '\u1F63', '\u1F65',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F67',        0,        0, '\u1FA1', },
    { '\u1F6A', '\u1F6C',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F6E',        0,        0, '\u1FA8', },
    { '\u1F6B', '\u1F6D',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1F6F',        0,        0, '\u1FA9', },
    { '\u1FCD', '\u1FCE',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FCF', },
    { '\u1FDD', '\u1FDE',        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u1FDF', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u3070', '\u3071', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u3073', '\u3074', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u3076', '\u3077', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u3079', '\u307A', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u307C', '\u307D', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u30D0', '\u30D1', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u30D3', '\u30D4', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u30D6', '\u30D7', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u30D9', '\u30DA', },
    {        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0,        0, '\u30DC', '\u30DD', },
  };
  public final static char[][] singleFirst = new char[][] {
    { '\u0338', '\u226E' },
    { '\u0338', '\u2260' },
    { '\u0338', '\u226F' },
    { '\u0307', '\u1E1E' },
    { '\u0302', '\u0134' },
    { '\u0307', '\u1E1F' },
    { '\u0304', '\u01DE' },
    { '\u0301', '\u01FA' },
    { '\u0301', '\u1E08' },
    { '\u0301', '\u1E2E' },
    { '\u0304', '\u022A' },
    { '\u0301', '\u01FE' },
    { '\u0304', '\u01DF' },
    { '\u0301', '\u01FB' },
    { '\u0301', '\u1E09' },
    { '\u0301', '\u1E2F' },
    { '\u0304', '\u022B' },
    { '\u0301', '\u01FF' },
    { '\u0307', '\u1E64' },
    { '\u0307', '\u1E65' },
    { '\u0307', '\u1E66' },
    { '\u0307', '\u1E67' },
    { '\u0301', '\u1E78' },
    { '\u0301', '\u1E79' },
    { '\u0308', '\u1E7A' },
    { '\u0308', '\u1E7B' },
    { '\u0307', '\u1E9B' },
    { '\u030C', '\u01EE' },
    { '\u0304', '\u01EC' },
    { '\u0304', '\u01ED' },
    { '\u0304', '\u01E0' },
    { '\u0304', '\u01E1' },
    { '\u0306', '\u1E1C' },
    { '\u0306', '\u1E1D' },
    { '\u0304', '\u0230' },
    { '\u0304', '\u0231' },
    { '\u030C', '\u01EF' },
    { '\u0314', '\u1FEC' },
    { '\u0345', '\u1FB4' },
    { '\u0345', '\u1FC4' },
    { '\u0345', '\u1FF4' },
    { '\u0308', '\u0407' },
    { '\u0301', '\u0403' },
    { '\u0308', '\u04DE' },
    { '\u0301', '\u040C' },
    { '\u0308', '\u04E6' },
    { '\u0308', '\u04F4' },
    { '\u0308', '\u04F8' },
    { '\u0308', '\u04EC' },
    { '\u0301', '\u0453' },
    { '\u0308', '\u04DF' },
    { '\u0301', '\u045C' },
    { '\u0308', '\u04E7' },
    { '\u0308', '\u04F5' },
    { '\u0308', '\u04F9' },
    { '\u0308', '\u04ED' },
    { '\u0308', '\u0457' },
    { '\u030F', '\u0476' },
    { '\u030F', '\u0477' },
    { '\u0308', '\u04DA' },
    { '\u0308', '\u04DB' },
    { '\u0308', '\u04EA' },
    { '\u0308', '\u04EB' },
    { '\u0654', '\u0624' },
    { '\u0654', '\u0626' },
    { '\u0654', '\u06C2' },
    { '\u0654', '\u06D3' },
    { '\u0654', '\u06C0' },
    { '\u093C', '\u0929' },
    { '\u093C', '\u0931' },
    { '\u093C', '\u0934' },
    { '\u0BD7', '\u0B94' },
    { '\u0BBE', '\u0BCB' },
    { '\u0C56', '\u0C48' },
    { '\u0CD5', '\u0CC0' },
    { '\u0CD5', '\u0CCB' },
    { '\u0D3E', '\u0D4B' },
    { '\u0DCA', '\u0DDD' },
    { '\u102E', '\u1026' },
    { '\u0304', '\u1E38' },
    { '\u0304', '\u1E39' },
    { '\u0304', '\u1E5C' },
    { '\u0304', '\u1E5D' },
    { '\u0307', '\u1E68' },
    { '\u0307', '\u1E69' },
    { '\u0302', '\u1EC6' },
    { '\u0302', '\u1EC7' },
    { '\u0302', '\u1ED8' },
    { '\u0302', '\u1ED9' },
    { '\u0345', '\u1F82' },
    { '\u0345', '\u1F83' },
    { '\u0345', '\u1F84' },
    { '\u0345', '\u1F85' },
    { '\u0345', '\u1F86' },
    { '\u0345', '\u1F87' },
    { '\u0345', '\u1F8A' },
    { '\u0345', '\u1F8B' },
    { '\u0345', '\u1F8C' },
    { '\u0345', '\u1F8D' },
    { '\u0345', '\u1F8E' },
    { '\u0345', '\u1F8F' },
    { '\u0345', '\u1F92' },
    { '\u0345', '\u1F93' },
    { '\u0345', '\u1F94' },
    { '\u0345', '\u1F95' },
    { '\u0345', '\u1F96' },
    { '\u0345', '\u1F97' },
    { '\u0345', '\u1F9A' },
    { '\u0345', '\u1F9B' },
    { '\u0345', '\u1F9C' },
    { '\u0345', '\u1F9D' },
    { '\u0345', '\u1F9E' },
    { '\u0345', '\u1F9F' },
    { '\u0345', '\u1FA2' },
    { '\u0345', '\u1FA3' },
    { '\u0345', '\u1FA4' },
    { '\u0345', '\u1FA5' },
    { '\u0345', '\u1FA6' },
    { '\u0345', '\u1FA7' },
    { '\u0345', '\u1FAA' },
    { '\u0345', '\u1FAB' },
    { '\u0345', '\u1FAC' },
    { '\u0345', '\u1FAD' },
    { '\u0345', '\u1FAE' },
    { '\u0345', '\u1FAF' },
    { '\u0345', '\u1FB2' },
    { '\u0345', '\u1FC2' },
    { '\u0345', '\u1FF2' },
    { '\u0345', '\u1FB7' },
    { '\u0345', '\u1FC7' },
    { '\u0345', '\u1FF7' },
    { '\u0338', '\u219A' },
    { '\u0338', '\u219B' },
    { '\u0338', '\u21AE' },
    { '\u0338', '\u21CD' },
    { '\u0338', '\u21CF' },
    { '\u0338', '\u21CE' },
    { '\u0338', '\u2204' },
    { '\u0338', '\u2209' },
    { '\u0338', '\u220C' },
    { '\u0338', '\u2224' },
    { '\u0338', '\u2226' },
    { '\u0338', '\u2241' },
    { '\u0338', '\u2244' },
    { '\u0338', '\u2247' },
    { '\u0338', '\u2249' },
    { '\u0338', '\u226D' },
    { '\u0338', '\u2262' },
    { '\u0338', '\u2270' },
    { '\u0338', '\u2271' },
    { '\u0338', '\u2274' },
    { '\u0338', '\u2275' },
    { '\u0338', '\u2278' },
    { '\u0338', '\u2279' },
    { '\u0338', '\u2280' },
    { '\u0338', '\u2281' },
    { '\u0338', '\u22E0' },
    { '\u0338', '\u22E1' },
    { '\u0338', '\u2284' },
    { '\u0338', '\u2285' },
    { '\u0338', '\u2288' },
    { '\u0338', '\u2289' },
    { '\u0338', '\u22E2' },
    { '\u0338', '\u22E3' },
    { '\u0338', '\u22AC' },
    { '\u0338', '\u22AD' },
    { '\u0338', '\u22AE' },
    { '\u0338', '\u22AF' },
    { '\u0338', '\u22EA' },
    { '\u0338', '\u22EB' },
    { '\u0338', '\u22EC' },
    { '\u0338', '\u22ED' },
    { '\u3099', '\u3094' },
    { '\u3099', '\u304C' },
    { '\u3099', '\u304E' },
    { '\u3099', '\u3050' },
    { '\u3099', '\u3052' },
    { '\u3099', '\u3054' },
    { '\u3099', '\u3056' },
    { '\u3099', '\u3058' },
    { '\u3099', '\u305A' },
    { '\u3099', '\u305C' },
    { '\u3099', '\u305E' },
    { '\u3099', '\u3060' },
    { '\u3099', '\u3062' },
    { '\u3099', '\u3065' },
    { '\u3099', '\u3067' },
    { '\u3099', '\u3069' },
    { '\u3099', '\u309E' },
    { '\u3099', '\u30F4' },
    { '\u3099', '\u30AC' },
    { '\u3099', '\u30AE' },
    { '\u3099', '\u30B0' },
    { '\u3099', '\u30B2' },
    { '\u3099', '\u30B4' },
    { '\u3099', '\u30B6' },
    { '\u3099', '\u30B8' },
    { '\u3099', '\u30BA' },
    { '\u3099', '\u30BC' },
    { '\u3099', '\u30BE' },
    { '\u3099', '\u30C0' },
    { '\u3099', '\u30C2' },
    { '\u3099', '\u30C5' },
    { '\u3099', '\u30C7' },
    { '\u3099', '\u30C9' },
    { '\u3099', '\u30F7' },
    { '\u3099', '\u30F8' },
    { '\u3099', '\u30F9' },
    { '\u3099', '\u30FA' },
    { '\u3099', '\u30FE' },
  };
  public final static char[][] singleSecond = new char[][] {
    { '\u0627', '\u0622' },
    { '\u0627', '\u0625' },
    { '\u09C7', '\u09CB' },
    { '\u09C7', '\u09CC' },
    { '\u0B47', '\u0B4B' },
    { '\u0B47', '\u0B48' },
    { '\u0B47', '\u0B4C' },
    { '\u0CC6', '\u0CCA' },
    { '\u0CC6', '\u0CC8' },
    { '\u0D46', '\u0D4C' },
    { '\u0DD9', '\u0DDC' },
    { '\u0DD9', '\u0DDE' },
  };
  public final static int multiSecondStart = 144;
  public final static int singleFirstStart = 181;
  public final static int singleSecondStart = 391;
  public final static int[] composePage = new int[] {
    0,
    1,
    2,
    3,
    4,
    -1,
    5,
    -1,
    -1,
    6,
    -1,
    7,
    8,
    9,
    -1,
    -1,
    10,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    11,
    12,
    -1,
    13,
    14,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    -1,
    15,
    -1,
  };
  public final static int[][] composeData = new int[][] {
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 181, 182, 183, -1, 
      -1, 0, 1, 2, 3, 4, 184, 5, 6, 7, 185, 8, 9, 10, 11, 12, 
      13, -1, 14, 15, 16, 17, 18, 19, 20, 21, 22, -1, -1, -1, -1, -1, 
      -1, 23, 24, 25, 26, 27, 186, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, -1, 38, 39, 40, 41, 42, 43, 44, 45, 46, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 47, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 48, -1, 187, 188, 49, 189, -1, -1, 50, -1, -1, -1, -1, 190, 
      -1, -1, -1, -1, 51, 52, 191, -1, 192, -1, -1, -1, 53, -1, -1, -1, 
      -1, -1, 54, -1, 193, 194, 55, 195, -1, -1, 56, -1, -1, -1, -1, 196, 
      -1, -1, -1, -1, 57, 58, 197, -1, 198, -1, -1, -1, 59, -1, -1, -1, 
    },
    {
      -1, -1, 60, 61, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64, 65, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 199, 200, -1, -1, -1, -1, 
      201, 202, -1, -1, -1, -1, -1, -1, 203, 204, 205, 206, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 207, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      66, 67, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, 
      69, -1, -1, -1, -1, -1, -1, 208, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 209, 210, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 211, 212, 213, 214, -1, -1, -1, -1, 215, 216, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 217, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      144, 145, 146, 147, 148, -1, 149, 150, 151, 152, 153, 165, 154, -1, -1, 155, 
      -1, 156, -1, 170, 171, -1, -1, -1, -1, -1, -1, 166, -1, -1, -1, -1, 
      -1, -1, -1, 157, 168, 158, 167, 161, 159, -1, -1, -1, -1, 162, 164, -1, 
      163, 160, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 169, -1, -1, 172, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, 70, -1, -1, -1, 71, -1, 72, -1, 73, -1, -1, -1, -1, -1, 74, 
      -1, 218, -1, -1, -1, 75, -1, -1, -1, 76, -1, -1, 219, -1, 220, -1, 
      -1, 77, -1, -1, -1, 78, -1, 79, -1, 80, -1, -1, -1, -1, -1, 81, 
      -1, 82, -1, -1, -1, 83, -1, -1, -1, 84, 85, 86, -1, -1, 221, -1, 
      -1, -1, 87, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, 222, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      88, -1, -1, 223, -1, 89, 90, 224, 91, -1, 225, -1, -1, -1, 226, -1, 
      -1, -1, -1, 92, -1, -1, -1, 227, -1, -1, -1, 228, -1, 229, -1, -1, 
      93, -1, -1, 230, -1, 94, 95, 231, 96, -1, 232, -1, -1, -1, 233, -1, 
      -1, -1, -1, 97, -1, -1, -1, 234, -1, -1, -1, 235, -1, 236, -1, -1, 
      -1, -1, -1, -1, -1, -1, 237, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, 238, 239, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 240, 241, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 242, 243, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, 98, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 244, -1, 245, -1, -1, -1, -1, -1, 
      -1, -1, -1, 391, 173, 392, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, 246, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 247, -1, -1, 248, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 249, -1, -1, -1, -1, -1, -1, -1, 
      250, -1, -1, 251, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 393, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, 394, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 395, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 396, 397, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 174, -1, 
      -1, -1, -1, -1, -1, -1, 99, 253, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, 175, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 254, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 255, 
      -1, -1, 398, -1, -1, -1, 100, -1, -1, -1, 256, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, 176, 399, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 177, -1, 
      -1, -1, -1, -1, -1, -1, 101, 257, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, 400, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 178, -1, -1, -1, -1, 401, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, 102, -1, -1, 258, -1, -1, 402, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 260, 261, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 262, 263, -1, -1, -1, -1, 
      -1, -1, 264, 265, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      103, 104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 268, 269, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      105, 106, 270, 271, 272, 273, 274, 275, 107, 108, 276, 277, 278, 279, 280, 281, 
      109, 110, -1, -1, -1, -1, -1, -1, 111, 112, -1, -1, -1, -1, -1, -1, 
      113, 114, 282, 283, 284, 285, 286, 287, 115, 116, 288, 289, 290, 291, 292, 293, 
      117, 118, -1, -1, -1, -1, -1, -1, 119, 120, -1, -1, -1, -1, -1, -1, 
      121, 122, -1, -1, -1, -1, -1, -1, 123, 124, -1, -1, -1, -1, -1, -1, 
      125, 126, -1, -1, -1, -1, -1, -1, -1, 127, -1, -1, -1, -1, -1, -1, 
      128, 129, 294, 295, 296, 297, 298, 299, 130, 131, 300, 301, 302, 303, 304, 305, 
      306, -1, -1, -1, 307, -1, -1, -1, -1, -1, -1, -1, 308, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 309, -1, -1, -1, -1, -1, -1, -1, -1, 132, 
      -1, -1, -1, -1, -1, -1, 310, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 311, -1, -1, -1, -1, -1, -1, -1, 133, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      312, -1, 313, -1, 314, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      315, -1, 316, -1, 317, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, 318, -1, -1, -1, -1, 319, -1, -1, 320, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, 321, -1, 322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 323, -1, -1, -1, 
      -1, -1, -1, 324, -1, 325, -1, -1, 326, -1, -1, -1, -1, 327, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, 328, -1, -1, 329, 330, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 331, 332, -1, -1, 333, 334, -1, -1, 335, 336, 337, 338, -1, -1, 
      -1, -1, 339, 340, -1, -1, 341, 342, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, 345, -1, -1, -1, -1, -1, 346, 347, -1, 348, -1, -1, -1, -1, 
      -1, -1, 349, 350, 351, 352, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    },
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, 353, -1, -1, -1, -1, 354, -1, 355, -1, 356, 
      -1, 357, -1, 358, -1, 359, -1, 360, -1, 361, -1, 362, -1, 363, -1, 364, 
      -1, 365, -1, -1, 366, -1, 367, -1, 368, -1, -1, -1, -1, -1, -1, 134, 
      -1, -1, 135, -1, -1, 136, -1, -1, 137, -1, -1, 138, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, 179, 180, -1, -1, 369, -1, -1, 
      -1, -1, -1, -1, -1, -1, 370, -1, -1, -1, -1, 371, -1, 372, -1, 373, 
      -1, 374, -1, 375, -1, 376, -1, 377, -1, 378, -1, 379, -1, 380, -1, 381, 
      -1, 382, -1, -1, 383, -1, 384, -1, 385, -1, -1, -1, -1, -1, -1, 139, 
      -1, -1, 140, -1, -1, 141, -1, -1, 142, -1, -1, 143, -1, -1, -1, -1, 
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 386, 
      387, 388, 389, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 390, -1, -1, 
    },
  };
}
