/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import javax.security.sasl.Sasl;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.auth.mechanisms.SaslSCRAMPlus;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:sasl-cb:0", parent=SessionManager.class, active=true)
public class SaslChannelBinding
extends XMPPProcessorAbstract {
    public static final String ID = "urn:xmpp:sasl-cb:0";
    @Inject
    protected TigaseSaslProvider saslProvider;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        return null;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        Collection<String> auth_mechs = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
        if (auth_mechs.isEmpty()) {
            return null;
        }
        if (session.isEncrypted() && session.getSessionData("LOCAL_CERTIFICATE_KEY") != null && SaslSCRAMPlus.containsScramPlus(auth_mechs)) {
            Element bindings = AbstractSaslSCRAM.getSupportedChannelBindings(session);
            return new Element[]{bindings};
        }
        return null;
    }
}

