/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.SaslInvalidLoginExcepion;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.XmppSaslException;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.AbstractAuthPreprocessor;
import tigase.xmpp.jid.BareJID;

public abstract class SaslAuthAbstract
extends AbstractAuthPreprocessor
implements XMPPProcessorIfc {
    protected static final String SASL_SERVER_KEY = "SASL_SERVER_KEY";
    private static final String SASL_SUCCESS_ELEMENT_NAME = "success";
    private static final String SASL_FAILURE_ELEMENT_NAME = "failure";
    protected static final String ALLOWED_SASL_MECHANISMS_KEY = "allowed-sasl-mechanisms";
    private static final Logger log = Logger.getLogger(SaslAuthAbstract.class.getName());
    protected final Map<String, Object> props = new HashMap<String, Object>();
    @Inject
    protected TigaseSaslProvider saslProvider;

    @Override
    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 4;
    }

    protected Packet createSaslErrorResponse(XmppSaslException.SaslError error, String message, Packet packet) {
        Element failure = new Element(SASL_FAILURE_ELEMENT_NAME);
        failure.setXMLNS(this.getXmlns());
        failure.addChild((XMLNodeIfc)(error == null ? XmppSaslException.SaslError.not_authorized : error).getElement());
        if (message != null) {
            failure.addChild((XMLNodeIfc)new Element("text", message, new String[]{"xml:lang"}, new String[]{"en"}));
        }
        Packet response = packet.swapFromTo(failure, null, null);
        response.setPriority(Priority.SYSTEM);
        return response;
    }

    @Override
    protected BareJID extractUserJid(Exception e, XMPPResourceConnection session) {
        BareJID jid = null;
        if (e instanceof SaslInvalidLoginExcepion) {
            String t = ((SaslInvalidLoginExcepion)e).getJid();
            BareJID bareJID = jid = t == null ? null : BareJID.bareJIDInstanceNS((String)t);
        }
        if (jid != null) {
            jid = super.extractUserJid(e, session);
        }
        return jid;
    }

    protected abstract String getXmlns();

    protected void onAuthFail(XMPPResourceConnection session) {
        session.removeSessionData(SASL_SERVER_KEY);
    }

    protected void processSessionAlreadyAuthorized(Packet packet, XMPPResourceConnection session, Queue<Packet> results) {
        Packet res = this.createSaslErrorResponse(null, null, packet);
        res.setPriority(Priority.SYSTEM);
        results.offer(res);
        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
        }
        try {
            session.logout();
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Session after logout: {0}", session.toString());
        }
    }

    protected abstract void processSuccess(Packet var1, XMPPResourceConnection var2, String var3, Queue<Packet> var4);
}

