/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disco.ServiceIdentity;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public class PresenceCapabilitiesManager {
    public static final String CAPS_NODE = "https://tigase.net/tigase-xmpp-server";
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final String charsetName = "UTF-8";
    private static final Map<String, String[]> nodeFeatures = new ConcurrentHashMap<String, String[]>(250);
    private static final ConcurrentMap<String, Set<String>> featureNodes = new ConcurrentHashMap<String, Set<String>>(250);
    private static final List<PresenceCapabilitiesListener> handlers = new CopyOnWriteArrayList<PresenceCapabilitiesListener>();
    private static long idCounter = 0L;
    private static Logger log = Logger.getLogger(PresenceCapabilitiesManager.class.getName());

    private static MessageDigest addValues(String[] features, MessageDigest md) throws UnsupportedEncodingException {
        if (features != null) {
            Arrays.sort(features);
            for (String f : features) {
                md.update(f.getBytes(charsetName));
                md.update((byte)60);
            }
        }
        return md;
    }

    public static String generateVerificationString(String[] identities, String[] features) {
        return PresenceCapabilitiesManager.generateVerificationString(identities, features, null);
    }

    public static String generateVerificationString(String[] identities, String[] features, Element extensions) {
        try {
            Set<String> fields;
            log.log(Level.FINEST, "Generating caps for identities: {0}, features: {1}, extensions: {2}", new String[]{Arrays.toString(identities), Arrays.toString(features), String.valueOf(extensions)});
            MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
            md = PresenceCapabilitiesManager.addValues(identities, md);
            md = PresenceCapabilitiesManager.addValues(features, md);
            if (extensions != null && (fields = DataForm.getFields(extensions)) != null) {
                md.update(DataForm.getFormType(extensions).getBytes(charsetName));
                md.update((byte)60);
                TreeSet<String> vars = new TreeSet<String>(fields);
                for (String var : vars) {
                    md.update(var.getBytes(charsetName));
                    md.update((byte)60);
                    String[] values = DataForm.getFieldValues(extensions, var);
                    PresenceCapabilitiesManager.addValues(values, md);
                }
            }
            byte[] digest = md.digest();
            return Base64.encode((byte[])digest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            log.warning("Cannot calculate verification string.");
            return null;
        }
    }

    public static String generateVerificationStringFromDiscoInfo(Element discoInfo) {
        String[] features = PresenceCapabilitiesManager.getFeaturesFromDiscoInfo(discoInfo);
        String[] identities = ServiceIdentity.getServiceIdentitiesCapsFromDiscoInfo(discoInfo);
        Element extension = discoInfo.getChild("x", "jabber:x:data");
        return PresenceCapabilitiesManager.generateVerificationString(identities, features, extension);
    }

    public static Element getCapsElement(String caps) {
        return new Element("c", new String[]{"xmlns", "hash", "node", "ver"}, new String[]{"http://jabber.org/protocol/caps", HASH_ALGORITHM.toLowerCase(), CAPS_NODE, caps});
    }

    public static String[] getFeaturesFromDiscoInfo(Element discoInfo) {
        String[] features = null;
        List featureElements = discoInfo.findChildren(child -> child.getName().equals("feature"));
        if (featureElements != null && !featureElements.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Element element : featureElements) {
                String var = element.getAttributeStaticStr("var");
                list.add(var);
            }
            features = list.toArray(new String[0]);
        }
        return features;
    }

    public static String[] getNodeFeatures(String capsNode) {
        return nodeFeatures.get(capsNode);
    }

    public static Set<String> getNodesWithFeature(String feature) {
        Set nodes = (Set)featureNodes.get(feature);
        if (nodes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(nodes);
    }

    public static void handlePresence(JID owner, JID from, String[] capsNodes, Queue<Packet> results) {
        if (capsNodes == null) {
            return;
        }
        List<PresenceCapabilitiesListener> handlers = PresenceCapabilitiesManager.handlers;
        for (PresenceCapabilitiesListener handler : handlers) {
            handler.handlePresence(owner, from, capsNodes, results);
        }
    }

    public static void prepareCapsQueries(JID compJid, JID to, String[] caps_nodes, Queue<Packet> results) {
        if (caps_nodes != null) {
            for (String caps_node : caps_nodes) {
                if (nodeFeatures.containsKey(caps_node)) continue;
                results.offer(PresenceCapabilitiesManager.prepareCapsQuery(to, compJid, caps_node));
            }
        }
    }

    public static void prepareCapsQueriesEl(JID compJid, JID to, String[] caps_nodes, Queue<Element> results) {
        if (caps_nodes != null) {
            for (String caps_node : caps_nodes) {
                if (nodeFeatures.containsKey(caps_node)) continue;
                results.offer(PresenceCapabilitiesManager.prepareCapsQueryEl(to, compJid, caps_node));
            }
        }
    }

    public static Packet prepareCapsQuery(JID to, JID from, String node) {
        Element iq = PresenceCapabilitiesManager.prepareCapsQueryEl(to, from, node);
        Iq iqPacket = new Iq(iq, from, to);
        iqPacket.setXMLNS("jabber:client");
        return iqPacket;
    }

    public static Element prepareCapsQueryEl(JID to, JID from, String node) {
        String id = String.valueOf(idCounter++);
        Element iq = new Element("iq", new String[]{"from", "to", "id", "type", "xmlns"}, new String[]{from.toString(), to.toString(), id, "get", "jabber:client"});
        Element query = new Element("query", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/disco#info", node});
        iq.addChild((XMLNodeIfc)query);
        return iq;
    }

    public static void processCapsQueryResponse(Packet packet) {
        Element query = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info");
        if (query != null && packet.getType() == StanzaType.result) {
            if (query.getAttributeStaticStr("node") == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("disco#info query without node attribute!");
                }
                return;
            }
            List ch = query.getChildren();
            if (ch != null) {
                ConcurrentSkipListSet<String> features = new ConcurrentSkipListSet<String>();
                for (Element item : ch) {
                    if (!"feature".equals(item.getName())) continue;
                    features.add(item.getAttributeStaticStr("var"));
                }
                PresenceCapabilitiesManager.setNodeFeatures(query.getAttributeStaticStr("node"), features.toArray(new String[features.size()]));
            }
        }
    }

    public static String[] processPresence(Element c) {
        HashSet<CallSite> caps_nodes = null;
        if (c != null) {
            caps_nodes = new HashSet<CallSite>();
            String caps_node = c.getAttributeStaticStr("node") + "#" + c.getAttributeStaticStr("ver");
            caps_nodes.add((CallSite)((Object)caps_node));
            if (c.getAttributeStaticStr("hash") == null && c.getAttributeStaticStr("ext") != null) {
                for (String e : c.getAttributeStaticStr("ext").split(" ")) {
                    caps_nodes.add((CallSite)((Object)(c.getAttributeStaticStr("node") + "#" + e)));
                }
            }
        } else {
            return null;
        }
        return caps_nodes.toArray(new String[caps_nodes.size()]);
    }

    public static String[] processPresence(JID compJid, Packet p, Queue<Packet> results) {
        String caps_node;
        Element c = p.getElement().getChild("c");
        HashSet features = new HashSet();
        if (c != null && !nodeFeatures.containsKey(caps_node = c.getAttributeStaticStr("node") + "#" + c.getAttributeStaticStr("ver"))) {
            HashSet<CallSite> caps_nodes = new HashSet<CallSite>();
            caps_nodes.add((CallSite)((Object)caps_node));
            if (c.getAttributeStaticStr("hash") == null && c.getAttributeStaticStr("ext") != null) {
                for (String e : c.getAttributeStaticStr("ext").split(" ")) {
                    caps_nodes.add((CallSite)((Object)(c.getAttributeStaticStr("node") + "#" + e)));
                }
            }
            for (String string : caps_nodes) {
                if (nodeFeatures.containsKey(string)) continue;
                results.offer(PresenceCapabilitiesManager.prepareCapsQuery(p.getFrom(), compJid, string));
            }
        }
        return features.toArray(new String[features.size()]);
    }

    public static void registerPresenceHandler(PresenceCapabilitiesListener handler) {
        handlers.add(handler);
    }

    public static void setNodeFeatures(String capsNode, String[] features) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "setting features for node = {0}, features = {1}", new Object[]{capsNode, Arrays.asList(features)});
        }
        Arrays.sort(features);
        nodeFeatures.put(capsNode, features);
        for (String feature : features) {
            CopyOnWriteArraySet<String> tmp;
            CopyOnWriteArraySet<String> caps = (CopyOnWriteArraySet<String>)featureNodes.get(feature);
            if (caps == null && (caps = (Set)featureNodes.putIfAbsent(feature, tmp = new CopyOnWriteArraySet<String>())) == null) {
                caps = tmp;
            }
            caps.add(capsNode);
        }
    }

    public static void unregisterPresenceHandler(PresenceCapabilitiesListener handler) {
        handlers.remove(handler);
    }

    public static interface PresenceCapabilitiesListener {
        public void handlePresence(JID var1, JID var2, String[] var3, Queue<Packet> var4);
    }
}

