/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.BruteForceLockerBean;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractAuthPreprocessor
extends XMPPProcessor
implements XMPPPreprocessorIfc {
    private static final Logger log = Logger.getLogger(AbstractAuthPreprocessor.class.getCanonicalName());
    private static final String[] AUTH_ONLY_ELEMS = new String[]{"message", "presence"};
    @Inject(nullAllowed=true)
    private BruteForceLockerBean bruteForceLocker;
    @ConfigField(desc="Matchers selecting allowed packets for unauthorized session", alias="allow-unauthorized")
    private ElementMatcher[] allowMatchers = new ElementMatcher[]{new ElementMatcher(new String[0], "urn:ietf:params:xml:ns:xmpp-tls", true), new ElementMatcher(new String[0], "http://jabber.org/protocol/compress", true), new ElementMatcher(new String[0], "urn:ietf:params:xml:ns:xmpp-sasl", true), new ElementMatcher(new String[0], "urn:xmpp:sasl:2", true), new ElementMatcher(Iq.IQ_QUERY_PATH, "jabber:iq:register", true), new ElementMatcher(Iq.IQ_QUERY_PATH, "jabber:iq:auth", true)};

    protected boolean isBruteForceLockerEnabled(XMPPResourceConnection session) {
        return this.bruteForceLocker != null && this.bruteForceLocker.isEnabled(session);
    }

    public void addInvalidLogin(XMPPResourceConnection session, String ip, BareJID jid) {
        this.bruteForceLocker.addInvalidLogin(session, ip, jid);
    }

    protected boolean isLoginAllowedByBruteForceLocker(XMPPResourceConnection session, String clientIp, BareJID jid) {
        return this.isBruteForceLockerEnabled(session) && !this.bruteForceLocker.isLoginAllowed(session, clientIp, jid);
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || session.isServerSession()) {
            return false;
        }
        try {
            if (session.getConnectionId().equals((Object)packet.getPacketFrom()) && !session.isAuthorized()) {
                for (String elem : AUTH_ONLY_ELEMS) {
                    if (packet.getElemName() != elem) continue;
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Packet received before the session has been authenticated.Session details: connectionId={0}, sessionId={1}, packet={2}", new Object[]{session.getConnectionId(), session.getSessionId(), packet.toStringSecure()});
                    }
                    return true;
                }
                if (!this.isPacketAllowed(packet)) {
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Packet received before the session has been authenticated.Session details: connectionId={0}, sessionId={1}, packet={2}", new Object[]{session.getConnectionId(), session.getSessionId(), packet.toStringSecure()});
                    }
                    return true;
                }
                return false;
            }
        }
        catch (PacketErrorTypeException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ignoring packet with an error to non-existen user session: {0}", packet.toStringSecure());
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Packet preprocessing exception: ", e);
            return false;
        }
        return false;
    }

    public String[] getAllowMatchers() {
        String[] result = new String[this.allowMatchers.length];
        for (int i = 0; i < this.allowMatchers.length; ++i) {
            result[i] = this.allowMatchers[i].toString();
        }
        return result;
    }

    protected void saveIntoBruteForceLocker(XMPPResourceConnection session, Exception e) {
        try {
            if (this.isBruteForceLockerEnabled(session)) {
                String clientIp = BruteForceLockerBean.getClientIp(session);
                BareJID userJid = this.extractUserJid(e, session);
                if (clientIp == null && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "There is no client IP. Cannot add entry to BruteForceLocker.");
                }
                if (userJid == null && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "There is no user JID. Cannot add entry to BruteForceLocker.");
                }
                if (userJid != null && clientIp != null) {
                    this.bruteForceLocker.addInvalidLogin(session, clientIp, userJid);
                }
                if (this.bruteForceLocker.canUserBeDisabled(session, clientIp, userJid)) {
                    this.disableUser(session, userJid);
                }
            }
        }
        catch (Throwable caught) {
            log.log(Level.WARNING, "Cannot update BruteForceLocker", caught);
        }
    }

    public void setAllowMatchers(String[] matcherStrs) {
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        for (String matcherStr : matcherStrs) {
            ElementMatcher matcher = ElementMatcher.create(matcherStr);
            if (matcher == null) continue;
            matchers.add(matcher);
        }
        this.allowMatchers = matchers.toArray(new ElementMatcher[0]);
    }

    protected boolean isPacketAllowed(Packet packet) {
        for (ElementMatcher matcher : this.allowMatchers) {
            if (!matcher.matches(packet)) continue;
            return matcher.getValue();
        }
        return false;
    }

    public void setBruteForceLocker(BruteForceLockerBean bruteForceLocker) {
        log.log(Level.CONFIG, bruteForceLocker != null ? "BruteForceLocker enabled" : "BruteForceLocker disabled");
        this.bruteForceLocker = bruteForceLocker;
    }

    protected void disableUser(XMPPResourceConnection session, BareJID userJID) {
        try {
            AuthRepository.AccountStatus status = session.getAuthRepository().getAccountStatus(userJID);
            if (status == AuthRepository.AccountStatus.active) {
                log.log(Level.CONFIG, "Disabling user " + String.valueOf(userJID));
                session.getAuthRepository().setAccountStatus(userJID, AuthRepository.AccountStatus.disabled);
            }
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINE, "Cannot check status or disable nonexistent user!", e);
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Cannot check status or disable user!", e);
        }
    }

    protected BareJID extractUserJid(Exception e, XMPPResourceConnection session) {
        return (BareJID)session.getSessionData("authentication-jid");
    }
}

