/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import java.util.List;
import tigase.server.Packet;
import tigase.xml.Element;

public class ElementMatcher {
    private final String[] path;
    private final boolean value;
    private final String xmlns;
    private final String[][] attributes;
    private final boolean checkChildren;

    public static ElementMatcher create(String str) {
        boolean value;
        ArrayList<String> path = new ArrayList<String>();
        String xmlns = null;
        ArrayList<String[]> attributes = new ArrayList<String[]>();
        boolean checkChildren = false;
        int offset = 0;
        boolean bl = value = !str.startsWith("-");
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            str = str.substring(1);
        }
        while (true) {
            String elemName = null;
            int slashIdx = str.indexOf(47, offset);
            int sIdx = str.indexOf(91, offset);
            if (slashIdx < 0) {
                slashIdx = str.length();
            }
            Object c = null;
            if (slashIdx < sIdx || sIdx < 0) {
                elemName = str.substring(offset, slashIdx);
                xmlns = null;
            } else {
                String[] parts;
                int eIdx = str.indexOf(93, sIdx);
                elemName = str.substring(offset, sIdx);
                String content = str.substring(sIdx + 1, eIdx);
                for (String part : parts = content.split(",")) {
                    int equalIdx = part.indexOf(61);
                    if (equalIdx > 0) {
                        attributes.add(new String[]{part.substring(0, equalIdx).intern(), part.substring(equalIdx + 1)});
                        continue;
                    }
                    xmlns = part;
                }
                slashIdx = str.indexOf(47, eIdx);
                if (slashIdx < 0) {
                    slashIdx = str.length();
                }
            }
            if (elemName != null && !elemName.isEmpty()) {
                if ("*".equals(elemName)) {
                    checkChildren = true;
                } else {
                    path.add(elemName.intern());
                }
            }
            if (slashIdx == str.length()) break;
            offset = slashIdx + 1;
        }
        if (xmlns != null) {
            xmlns = xmlns.intern();
        }
        return new ElementMatcher(path.toArray(new String[0]), checkChildren, xmlns, attributes.isEmpty() ? null : (String[][])attributes.stream().toArray(x$0 -> new String[x$0][]), value);
    }

    public ElementMatcher(String[] path, String xmlns, boolean value) {
        this(path, false, xmlns, null, value);
    }

    public ElementMatcher(String[] path, boolean checkChildren, String xmlns, String[][] attributes, boolean value) {
        this.path = path;
        this.xmlns = xmlns;
        this.attributes = attributes;
        this.value = value;
        this.checkChildren = checkChildren;
    }

    public boolean matches(Packet packet) {
        Element child;
        Element element = child = this.path.length == 0 ? packet.getElement() : packet.getElement().findChildStaticStr(this.path);
        if (this.checkChildren) {
            if (child == null) {
                return false;
            }
            List children = child.getChildren();
            if (children == null) {
                return false;
            }
            for (Element el : children) {
                if (!this.matches(el)) continue;
                return true;
            }
            return false;
        }
        return this.matches(child);
    }

    protected boolean matches(Element child) {
        if (child == null) {
            return false;
        }
        if (this.xmlns != null && this.xmlns != child.getXMLNS()) {
            return false;
        }
        if (this.attributes != null) {
            for (String[] pair : this.attributes) {
                if (pair[1].equals(child.getAttributeStaticStr(pair[0]))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.value) {
            sb.append('-');
        }
        for (String p : this.path) {
            sb.append('/');
            sb.append(p);
        }
        if (this.checkChildren) {
            sb.append("/*");
        }
        if (this.xmlns != null || this.attributes != null) {
            sb.append("[");
            if (this.xmlns != null) {
                sb.append(this.xmlns);
            }
            if (this.attributes != null && this.attributes.length > 0) {
                boolean first = this.xmlns == null;
                for (String[] pair : this.attributes) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(pair[0]).append("=").append(pair[1]);
                }
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

