/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession.adhoc;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.xmppserver.KnownDomainsListProvider;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="tigase:instance:details#domains", parent=SessionManager.class, active=true, exportable=true)
public class SuggestedDomainsListAdhoc
implements AdHocCommand {
    protected static final String XMLNS = "tigase:instance:details#domains";
    private static final Logger log = Logger.getLogger(SuggestedDomainsListAdhoc.class.getCanonicalName());
    @Inject
    private KnownDomainsListProvider knownDomainsListProvider;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            response.getElements().add(this.prepareForm().getElement());
            response.completeSession();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Exception during execution of adhoc command " + this.getNode(), e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Information about domains on this instance";
    }

    @Override
    public String getNode() {
        return XMLNS;
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return false;
    }

    @Override
    public boolean isAllowedFor(JID from, JID to) {
        return to == null || from.getBareJID().equals((Object)to.getBareJID());
    }

    @Override
    public boolean isForSelf() {
        return true;
    }

    protected Form prepareForm() {
        Form form = new Form("form", "Know local and remote domains", "Form used to obtain list of all know local and remote domains");
        String[] localDomains = (String[])this.knownDomainsListProvider.getAllLocalDomains().toArray(String[]::new);
        String[] knownRemoteDomains = (String[])this.knownDomainsListProvider.getAuthenticatedRemoteDomains().toArray(String[]::new);
        form.addField(Field.fieldTextMulti((String)"knownRemoteDomains", (String[])knownRemoteDomains, (String)"List of known remote domains"));
        form.addField(Field.fieldTextMulti((String)"localDomains", (String[])localDomains, (String)"List of local instance domains"));
        return form;
    }
}

