/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.script;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tigase.server.BasicComponent;
import tigase.server.CmdAcl;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.AbstractScriptCommand;
import tigase.server.script.Script;

public class AddScriptCommand
extends AbstractScriptCommand {
    private static final Logger log = Logger.getLogger(AddScriptCommand.class.getName());

    public Script addAdminScript(String cmdId, String cmdDescr, String cmdGroup, String script, String lang, String ext, Bindings binds) throws ScriptException {
        Script as = new Script();
        as.init(cmdId, cmdDescr, cmdGroup, script, lang, ext, binds);
        Map adminCommands = (Map)binds.get("adminCommands");
        adminCommands.put(as.getCommandId(), as);
        Map commandsACL = (Map)binds.get("cmdsAcl");
        Set acl = (Set)commandsACL.get(as.getCommandId());
        if (acl != null) {
            for (CmdAcl cmdAcl : acl) {
                if (cmdAcl.getType() == CmdAcl.Type.ADMIN) continue;
                as.setAdminOnly(false);
                break;
            }
        }
        return as;
    }

    @Override
    public Bindings getBindings() {
        return null;
    }

    @Override
    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        String language = Command.getFieldValue(packet, "Language");
        String commandId = Command.getFieldValue(packet, "Command Id");
        String description = Command.getFieldValue(packet, "Description");
        String group = Command.getFieldValue(packet, "Group");
        String[] scriptText = Command.getFieldValues(packet, "Script text");
        boolean saveToDisk = Command.getCheckBoxFieldValue(packet, "Save to disk");
        if (this.isEmpty(language) || this.isEmpty(commandId) || this.isEmpty(description) || scriptText == null) {
            results.offer(this.prepareScriptCommand(packet, binds));
        } else {
            StringBuilder sb = new StringBuilder(1024);
            for (String string : scriptText) {
                if (string == null) continue;
                sb.append(string).append("\n");
            }
            try {
                BasicComponent component;
                String originalGroup = group;
                if (group != null && group.contains("${componentName}") && (component = (BasicComponent)binds.get("component")) != null) {
                    group = group.replace("${componentName}", component.getDiscoDescription());
                }
                Script s = this.addAdminScript(commandId, description, group, sb.toString(), language, null, binds);
                Packet result = packet.commandResult(Command.DataType.result);
                Command.addTextField(result, "Note", "Script loaded successfuly.");
                results.offer(result);
                if (saveToDisk) {
                    this.saveCommandToDisk(commandId, description, originalGroup, sb, s.getFileExtension(), binds);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can''t initialize script: ", e);
                Packet result = packet.commandResult(Command.DataType.result);
                Command.addTextField(result, "Note", "Script initialization error.");
                StackTraceElement[] ste = e.getStackTrace();
                String[] error = new String[ste.length + 2];
                error[0] = e.getMessage();
                error[1] = e.toString();
                for (int i = 0; i < ste.length; ++i) {
                    error[i + 2] = ste[i].toString();
                }
                Command.addTextField(result, "Error message", e.getMessage());
                Command.addFieldMultiValue(result, "Debug info", Arrays.asList(error));
                results.offer(result);
            }
        }
    }

    private Packet prepareScriptCommand(Iq packet, Bindings binds) {
        Packet result = packet.commandResult(Command.DataType.form);
        Command.addFieldValue(result, "Description", "Short description");
        Command.addFieldValue(result, "Command Id", "new-command");
        Command.addFieldValue(result, "Group", "group");
        ScriptEngineManager scriptEngineManager = (ScriptEngineManager)binds.get("scriptManager");
        List<ScriptEngineFactory> scriptFactories = scriptEngineManager.getEngineFactories();
        if (scriptFactories != null) {
            String[] langs = new String[scriptFactories.size()];
            int idx = 0;
            String def = null;
            for (ScriptEngineFactory scriptEngineFactory : scriptFactories) {
                langs[idx++] = scriptEngineFactory.getLanguageName();
                if (!scriptEngineFactory.getLanguageName().equals("groovy")) continue;
                def = "groovy";
            }
            if (def == null) {
                def = langs[0];
            }
            Command.addFieldValue(result, "Language", def, "Language", langs, langs);
        }
        Command.addFieldMultiValue(result, "Script text", Collections.nCopies(1, ""));
        Command.addCheckBoxField(result, "Save to disk", true);
        return result;
    }

    private void saveCommandToDisk(String commandId, String description, String group, StringBuilder sb, String fileExtension, Bindings binds) throws IOException {
        File fileName = new File((String)binds.get("scriptCompDir"), commandId + "." + fileExtension);
        File parentDirectory = fileName.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            log.log(Level.CONFIG, "Admin scripts directory is missing: {0}, creating...", parentDirectory);
            try {
                parentDirectory.mkdirs();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can''t create scripts directory , read-only filesystem: " + String.valueOf(parentDirectory), e);
            }
        }
        log.log(Level.CONFIG, "Saving command: {0} to disk file: {1}", new Object[]{commandId, fileName.toString()});
        FileWriter fw = new FileWriter(fileName, false);
        String comment = (String)lineCommentStart.get(fileExtension);
        if (comment == null) {
            comment = "//";
        }
        fw.write(comment + " AS:Description: " + description + "\n");
        fw.write(comment + " AS:CommandId: " + commandId + "\n");
        fw.write(comment + " AS:Component: " + String.valueOf(binds.get("componentName")) + "\n");
        if (group != null) {
            fw.write(comment + " AS:Group: " + group + "\n");
        }
        fw.write(sb.toString());
        fw.close();
    }
}

