/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import tigase.eventbus.EventBusEvent;
import tigase.util.datetime.TimestampHelper;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.dns.DNSResolverIfc;

public abstract class TasksEvent
implements EventBusEvent {
    private static final TimestampHelper dtf = new TimestampHelper();
    private final DNSResolverIfc dnsResolver = DNSResolverFactory.getInstance();
    String description;
    String external_hostname;
    String hostname;
    String name;
    String timestamp;

    public TasksEvent(String name, String description) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        this.name = name;
        this.description = description;
        this.timestamp = dtf.format(new Date());
        this.hostname = this.dnsResolver.getDefaultHost();
        this.external_hostname = this.dnsResolver.getSecondaryHost();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TasksEvent that = (TasksEvent)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        if (!this.hostname.equals(that.hostname)) {
            return false;
        }
        return this.external_hostname.equals(that.external_hostname);
    }

    public String asString() {
        return this.getAdditionalData().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\n"));
    }

    public abstract Map<String, String> getAdditionalData();

    public String getDescription() {
        return this.description;
    }

    public String getExternal_hostname() {
        return this.external_hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getName() {
        return this.name;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.hostname.hashCode();
        result = 31 * result + this.external_hostname.hashCode();
        return result;
    }
}

