/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.IOInterface;

public class SampleSocketThread
extends Thread {
    private static final Logger log = Logger.getLogger("tigase.io.SampleSocketThread");
    private final ConcurrentLinkedQueue<IOInterface> for_removal = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IOInterface> waiting = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<InetSocketAddress> waiting_accept = new ConcurrentLinkedQueue();
    private Selector clientSel = null;
    private SocketHandler handler = null;
    private boolean stopping = false;

    public SampleSocketThread(SocketHandler handler) throws IOException {
        this.handler = handler;
        this.clientSel = Selector.open();
        this.setName("SampleSocketThread");
    }

    public void addIOInterface(IOInterface s) {
        this.waiting.offer(s);
        this.clientSel.wakeup();
    }

    public void addForAccept(InetSocketAddress isa) {
        this.waiting_accept.offer(isa);
        this.clientSel.wakeup();
    }

    public void removeIOInterface(IOInterface s) {
        SelectionKey key = s.getSocketChannel().keyFor(this.clientSel);
        if (key != null && key.attachment() == s) {
            key.cancel();
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                this.clientSel.select();
                Iterator<SelectionKey> i = this.clientSel.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey sk = i.next();
                    i.remove();
                    if ((sk.readyOps() & 0x10) != 0) {
                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                        SocketChannel sc = nextReady.accept();
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Registered new client socket: " + String.valueOf(sc));
                        }
                        this.handler.handleSocketAccept(sc);
                    }
                    if ((sk.readyOps() & 8) != 0) {
                        // empty if block
                    }
                    if ((sk.readyOps() & 1) == 0) continue;
                    IOInterface s = (IOInterface)sk.attachment();
                    sk.cancel();
                    this.handler.handleIOInterface(s);
                }
                this.clientSel.selectNow();
                this.addAllWaiting();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "SampleSocketThread I/O error, can't continue my work.", e);
                this.stopping = true;
            }
        }
        System.err.println("SampleSocketThread stopped!");
        System.exit(2);
    }

    private void addAllWaiting() throws IOException {
        IOInterface s = null;
        while ((s = this.waiting.poll()) != null) {
            SocketChannel sc = s.getSocketChannel();
            try {
                sc.register(this.clientSel, 1, s);
            }
            catch (Exception exception) {}
        }
        InetSocketAddress isa = null;
        while ((isa = this.waiting_accept.poll()) != null) {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            ssc.socket().bind(isa);
            ssc.register(this.clientSel, 16, null);
        }
    }

    public static interface SocketHandler {
        public void handleIOInterface(IOInterface var1) throws IOException;

        public void handleSocketAccept(SocketChannel var1) throws IOException;
    }
}

