/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.eventbus.EventListener;
import tigase.eventbus.component.AbstractEventBusModule;
import tigase.eventbus.component.ElemPathCriteria;
import tigase.eventbus.component.EventBusComponent;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.component.stores.SubscriptionStore;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.eventbus.impl.EventName;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="unsubscribe", active=true)
public class UnsubscribeModule
extends AbstractEventBusModule
implements Initializable,
UnregisterAware {
    public static final String ID = "unsubscribe";
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"iq", "pubsub", "unsubscribe"}, new String[]{null, "http://jabber.org/protocol/pubsub", null});
    @Inject
    private EventBusComponent component;
    @Inject(nullAllowed=false, bean="localEventBus")
    private EventBusImplementation localEventBus;
    private final EventListener<EventBusImplementation.ListenerRemovedEvent> eventBusHandlerRemovedHandler = new EventListener<EventBusImplementation.ListenerRemovedEvent>(){

        @Override
        public void onEvent(EventBusImplementation.ListenerRemovedEvent event) {
            if (!event.getPackageName().startsWith("tigase.eventbus")) {
                UnsubscribeModule.this.onRemoveHandler(event.getPackageName(), event.getEventName());
            }
        }
    };
    @Inject
    private SubscriptionStore subscriptionStore;

    @Override
    public void beforeUnregister() {
        this.localEventBus.removeListener(this.eventBusHandlerRemovedHandler);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#subscribe"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void initialize() {
        this.localEventBus.addListener(EventBusImplementation.ListenerRemovedEvent.class, this.eventBusHandlerRemovedHandler);
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() != StanzaType.set) {
            throw new ComponentException(Authorization.NOT_ALLOWED);
        }
        this.processSet(packet);
    }

    protected void onRemoveHandler(String eventPackage, String eventName) {
        boolean listenedByHandlers = this.localEventBus.isListened(eventPackage, eventName);
        if (!listenedByHandlers) {
            for (JID node : this.component.getNodesConnected()) {
                Element se = this.prepareUnsubscribeElement(new EventName(eventPackage, eventName), this.component.getComponentId(), null);
                this.sendUnsubscribeRequest("eventbus@" + node.getDomain(), Collections.singleton(se));
            }
        }
    }

    protected void sendUnsubscribeRequest(String to, Collection<Element> subscriptionElement) {
        try {
            Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{this.component.getComponentId().toString(), to, "set", this.nextStanzaID()});
            Element pubsubElem = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            iq.addChild((XMLNodeIfc)pubsubElem);
            for (Element node : subscriptionElement) {
                pubsubElem.addChild((XMLNodeIfc)node);
            }
            Packet packet = Packet.packetInstance(iq);
            packet.setPermissions(Permissions.ADMIN);
            packet.setXMLNS("jabber:client");
            this.write(packet, new AsyncCallback(this){

                @Override
                public void onError(Packet responseStanza, String errorCondition) {
                }

                @Override
                public void onSuccess(Packet responseStanza) {
                }

                @Override
                public void onTimeout() {
                }
            });
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Error creating packet instance", e);
        }
    }

    private Element prepareUnsubscribeElement(EventName event, JID jid, String service) {
        Element subscribeElem = new Element(ID);
        subscribeElem.addAttribute("node", event.toString());
        subscribeElem.addAttribute("jid", jid.toString());
        if (service != null) {
            subscribeElem.addChild((XMLNodeIfc)new Element("service", service));
        }
        return subscribeElem;
    }

    private void processSet(Packet packet) throws TigaseStringprepException {
        List<Element> unsubscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        if (this.isClusteredEventBus(packet.getStanzaFrom())) {
            for (Element unsubscribe : unsubscribeElements) {
                EventName parsedName = new EventName(unsubscribe.getAttributeStaticStr("node"));
                JID jid = JID.jidInstance((String)unsubscribe.getAttributeStaticStr("jid"));
                this.subscriptionStore.removeSubscription(parsedName.getPackage(), parsedName.getName(), new Subscription(jid));
            }
        } else {
            HashSet<Element> subscribedNodes = new HashSet<Element>();
            for (Element subscribe : unsubscribeElements) {
                EventName parsedName = new EventName(subscribe.getAttributeStaticStr("node"));
                JID jid = JID.jidInstance((String)subscribe.getAttributeStaticStr("jid"));
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Entity " + String.valueOf(jid) + " subscribed for events " + String.valueOf(parsedName));
                }
                this.subscriptionStore.removeSubscription(parsedName.getPackage(), parsedName.getName(), new Subscription(jid, packet.getStanzaTo()));
                subscribedNodes.add(this.prepareUnsubscribeElement(parsedName, jid, packet.getStanzaTo().toString()));
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Forwarding unsubcribe to: " + String.valueOf(this.component.getNodesConnected()));
            }
            for (JID node : this.component.getNodesConnected()) {
                this.sendUnsubscribeRequest("eventbus@" + node.getDomain(), subscribedNodes);
            }
        }
        Packet response = packet.okResult((Element)null, 0);
        response.setPermissions(Permissions.ADMIN);
        this.write(response);
    }
}

