/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.eventbus.component.stores.Affiliation;
import tigase.eventbus.component.stores.AffiliationStore;
import tigase.eventbus.impl.EventName;
import tigase.eventbus.impl.EventsRegistrar;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.jid.JID;

@Bean(name="disco", active=true)
public class EventbusDiscoveryModule
extends DiscoveryModule {
    @Inject
    private AffiliationStore affiliationStore;
    @Inject
    private EventsRegistrar registrar;

    @Override
    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Affiliation affiliation = this.affiliationStore.getAffiliation(packet.getStanzaFrom());
        if (node == null || !affiliation.isSubscribe()) {
            super.processDiscoInfo(packet, jid, node, senderJID);
        } else {
            Map<String, Set<String>> tree = this.prepareEventsTree();
            Element resultQuery = new Element("query", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/disco#info", node});
            Packet resultIq = packet.okResult(resultQuery, 0);
            if (tree.containsKey(node)) {
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "collection"}));
            } else if (this.registrar.isRegistered(node)) {
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "leaf"}));
            } else {
                try {
                    this.write(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown event", true));
                    return;
                }
                catch (PacketErrorTypeException e) {
                    throw new RuntimeException(e);
                }
            }
            resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
            this.write(resultIq);
        }
    }

    @Override
    protected void processDiscoItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Affiliation affiliation = this.affiliationStore.getAffiliation(packet.getStanzaFrom());
        if (!affiliation.isSubscribe()) {
            this.write(packet.okResult(new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"}), 0));
            return;
        }
        Map<String, Set<String>> tree = this.prepareEventsTree();
        if (node == null) {
            ArrayList<Element> items = new ArrayList<Element>();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            Packet result = packet.okResult(resultQuery, 0);
            for (String n : tree.keySet()) {
                items.add(new Element("item", new String[]{"jid", "node", "name"}, new String[]{jid.toString(), n, n}));
            }
            resultQuery.addChildren(items);
            this.write(result);
        } else if (tree.containsKey(node)) {
            ArrayList<Element> items = new ArrayList<Element>();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            Packet result = packet.okResult(resultQuery, 0);
            for (String eventName : tree.get(node)) {
                String description = this.registrar.getDescription(eventName);
                items.add(new Element("item", new String[]{"jid", "node", "name"}, new String[]{jid.toString(), eventName, description == null || description.isEmpty() ? eventName : description}));
            }
            resultQuery.addChildren(items);
            this.write(result);
        } else {
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
            this.write(packet.okResult(resultQuery, 0));
        }
    }

    private Map<String, Set<String>> prepareEventsTree() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String e : this.registrar.getRegisteredEvents()) {
            Set<String> nodes;
            EventName name = new EventName(e);
            String pck = name.getPackage() + ".*";
            if (result.containsKey(pck)) {
                nodes = (Set)result.get(pck);
            } else {
                nodes = new HashSet();
                result.put(pck, nodes);
            }
            nodes.add(e);
        }
        return result;
    }
}

