/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SchemaManagerLogHandler
extends Handler {
    private final ArrayDeque<LogRecord> queue = new ArrayDeque();
    private static Formatter simpleLogFormatter = new SchemaLogFormatter();

    @Override
    public void publish(LogRecord record) {
        this.queue.offer(record);
    }

    @Override
    public void flush() {
        this.queue.clear();
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    public LogRecord poll() {
        return this.queue.poll();
    }

    public Optional<String> getMessage() {
        LogRecord rec;
        StringBuilder sb = null;
        while ((rec = this.poll()) != null) {
            if (rec.getLevel().intValue() <= Level.CONFIG.intValue() || rec.getMessage() == null) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append(simpleLogFormatter.format(rec));
        }
        return sb == null ? Optional.empty() : Optional.of(sb.toString());
    }

    private static class SchemaLogFormatter
    extends Formatter {
        private SchemaLogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return this.formatMessage(record);
        }
    }
}

