/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractAuthRepositoryWithCredentials
implements AuthRepository {
    private static final Logger log = Logger.getLogger(AbstractAuthRepositoryWithCredentials.class.getCanonicalName());
    private CredentialsDecoderBean credentialsDecoder;
    private CredentialsEncoderBean credentialsEncoder;

    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        Credentials credentials = this.getCredentials(user, "default");
        if (credentials != null) {
            Credentials.Entry entry = credentials.getEntryForMechanism("PLAIN");
            if (entry != null && entry instanceof PlainCredentialsEntry) {
                return ((PlainCredentialsEntry)entry).getPassword();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No password in plaintext stored for user {0}, returning null...", user);
            }
        }
        return null;
    }

    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        if ("PLAIN".equals(mechanism)) {
            return true;
        }
        if (mechanism.endsWith("-PLUS")) {
            mechanism = mechanism.substring(0, mechanism.length() - "-PLUS".length());
        }
        return this.credentialsDecoder.getSupportedMechanisms().contains(mechanism);
    }

    @Override
    public void setCredentialsCodecs(CredentialsEncoderBean encoder, CredentialsDecoderBean decoder) {
        this.credentialsEncoder = encoder;
        this.credentialsDecoder = decoder;
    }

    protected CredentialsDecoderBean getCredentialsDecoder() {
        return this.credentialsDecoder;
    }

    protected CredentialsEncoderBean getCredentialsEncoder() {
        return this.credentialsEncoder;
    }
}

