/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.BackwardCompatibilityHelper;
import tigase.component.DSLBeanConfigurator;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.db.comp.ComponentRepository;
import tigase.kernel.core.BeanConfig;

public class DSLBeanConfiguratorWithBackwardCompatibility
extends DSLBeanConfigurator {
    private static final Logger log = Logger.getLogger(DSLBeanConfiguratorWithBackwardCompatibility.class.getCanonicalName());

    @Override
    public void configure(BeanConfig beanConfig, Object bean, Map<String, Object> values) {
        super.configure(beanConfig, bean, values);
        try {
            HashMap<String, Object> props;
            Map<String, Object> params;
            String dbUri;
            String configType;
            Method setPropertiesMethod;
            Method getDefaultsMethod;
            Object conf;
            if (bean instanceof Configurable) {
                conf = (Configurable)bean;
                getDefaultsMethod = bean.getClass().getMethod("getDefaults", Map.class);
                setPropertiesMethod = bean.getClass().getMethod("setProperties", Map.class);
                if (getDefaultsMethod != null && getDefaultsMethod.getAnnotation(Deprecated.class) == null) {
                    log.log(Level.WARNING, "Class {0} is using deprecated configuration using methods getDefaults() and setProperties()", bean.getClass().getCanonicalName());
                }
                if (setPropertiesMethod != null && setPropertiesMethod.getAnnotation(Deprecated.class) == null) {
                    configType = (String)this.getProperties().getOrDefault("config-type", "--gen-config-default");
                    dbUri = (String)this.getPropertyAtPath("dataSource", "repo-uri");
                    params = BackwardCompatibilityHelper.getDefConfigParams(this.getKernel(), configType, dbUri, this.getProperties());
                    props = new HashMap<String, Object>(params);
                    props.putAll(conf.getDefaults(params));
                    this.fillProps(beanConfig, props);
                    ((Configurable)bean).setProperties(props);
                }
            }
            if (bean instanceof ComponentRepository) {
                conf = (ComponentRepository)bean;
                getDefaultsMethod = bean.getClass().getMethod("getDefaults", Map.class, Map.class);
                setPropertiesMethod = bean.getClass().getMethod("setProperties", Map.class);
                if (getDefaultsMethod != null && getDefaultsMethod.getAnnotation(Deprecated.class) == null) {
                    log.log(Level.WARNING, "Class {0} is using deprecated configuration using methods getDefaults() and setProperties()", bean.getClass().getCanonicalName());
                }
                if (setPropertiesMethod != null && setPropertiesMethod.getAnnotation(Deprecated.class) == null) {
                    configType = (String)this.getProperties().getOrDefault("config-type", "--gen-config-default");
                    dbUri = (String)this.getPropertyAtPath("dataSource", "repo-uri");
                    params = BackwardCompatibilityHelper.getDefConfigParams(this.getKernel(), configType, dbUri, this.getProperties());
                    props = new HashMap();
                    conf.getDefaults(props, params);
                    this.fillProps(beanConfig, props);
                    ((ComponentRepository)bean).setProperties(props);
                }
            }
        }
        catch (NoSuchMethodException conf) {
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("Could not configure bean " + beanConfig.getBeanName(), ex);
        }
    }

    public Map<String, Object> getBeanConfigurationProperties(BeanConfig beanConfig) {
        return this.getBeanConfigurationProperties(beanConfig, Collections.emptyMap());
    }

    private void fillProps(BeanConfig beanConfig, Map<String, Object> result) {
        Map<String, Object> props = this.getBeanConfigurationProperties(beanConfig);
        result.putAll(BackwardCompatibilityHelper.fillProps(props));
    }

    private <T> T getPropertyAtPath(String ... path) {
        Object val = this.getProperties();
        for (int i = 0; i < path.length && (val = val.get(path[i])) != null; ++i) {
        }
        return (T)val;
    }
}

