/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.repo.ClConRepoDefaults;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.db.DBInitException;
import tigase.db.comp.ConfigRepository;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigAlias;
import tigase.kernel.beans.config.ConfigAliases;
import tigase.kernel.beans.config.ConfigField;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.util.dns.DNSResolverFactory;

@ConfigAliases(value={@ConfigAlias(field="items", alias="cluster-nodes")})
public class ClConConfigRepository
extends ConfigRepository<ClusterRepoItem>
implements ShutdownHook,
Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(ClConConfigRepository.class.getName());
    @ConfigField(desc="Automatically remove obsolote items", alias="repo-auto-remove-obsolete-items")
    protected boolean auto_remove_obsolete_items = true;
    protected boolean firstLoadDone = false;
    protected long lastReloadTime = 0L;
    protected long lastReloadTimeFactor = 10L;
    @Inject
    private EventBus eventBus;

    public ClConConfigRepository() {
        this.autoReloadInterval = 15L;
        if (this.getItem(DNSResolverFactory.getInstance().getDefaultHost()) == null) {
            ClusterRepoItem item = this.getItemInstance();
            item.initFromPropertyString(DNSResolverFactory.getInstance().getDefaultHost());
            this.addItem(item);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return ClConRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public String getName() {
        return "Cluster repository clean-up";
    }

    @Override
    public String getPropertyKey() {
        return ClConRepoDefaults.getPropertyKey();
    }

    @Override
    public String getConfigKey() {
        return ClConRepoDefaults.getConfigKey();
    }

    @Override
    public ClusterRepoItem getItemInstance() {
        return ClConRepoDefaults.getItemInstance();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void reload() {
        ClusterRepoItem item;
        String host;
        block8: {
            super.reload();
            host = DNSResolverFactory.getInstance().getDefaultHost();
            if (!this.firstLoadDone) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "First Cluster repository reload done: {0}, items size: {1}, last updated own item: {2}", new Object[]{this.firstLoadDone, this.items.size(), ((ClusterRepoItem)this.items.get(host)).getLastUpdate()});
                }
                if (this.items.get(host) != null && ((ClusterRepoItem)this.items.get(host)).getLastUpdate() > 0L) {
                    this.firstLoadDone = true;
                    if (this.items.size() == 1) {
                        this.eventBus.fire(new ClusterConnectionManager.ClusterInitializedEvent());
                    }
                }
            }
            item = (ClusterRepoItem)this.getItem(host);
            try {
                item = item != null ? (ClusterRepoItem)item.clone() : null;
            }
            catch (CloneNotSupportedException ex) {
                if (!log.isLoggable(Level.FINEST)) break block8;
                log.log(Level.SEVERE, "Cloning of ClusterRepoItem has failed", ex);
            }
        }
        if (item == null) {
            item = this.getItemInstance();
            item.setHostname(host);
        }
        item.setSecondaryHostname(DNSResolverFactory.getInstance().getSecondaryHost());
        item.setLastUpdate(System.currentTimeMillis());
        item.setCpuUsage(TigaseRuntime.getTigaseRuntime().getCPUUsage());
        item.setMemUsage(TigaseRuntime.getTigaseRuntime().getHeapMemUsage());
        this.storeItem(item);
        if (this.auto_remove_obsolete_items) {
            this.removeObsoloteItems(6000L);
        }
    }

    public void itemLoaded(ClusterRepoItem item) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Item loaded: {0}", item);
        }
        if (System.currentTimeMillis() - item.getLastUpdate() <= 5000L * this.autoReloadInterval && this.clusterRecordValid(item)) {
            this.addItem(item);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Removing stale item: {0}; current time: {1}, last update: {2} ({3}), diff: {4}, autoreload {5}", new Object[]{item, System.currentTimeMillis(), item.getLastUpdate(), new Date(item.getLastUpdate()), System.currentTimeMillis() - item.getLastUpdate(), 5000L * this.autoReloadInterval});
            }
            if (this.auto_remove_obsolete_items) {
                this.removeItem(item.getHostname());
            }
        }
    }

    @Override
    public boolean itemChanged(ClusterRepoItem oldItem, ClusterRepoItem newItem) {
        return !oldItem.getPassword().equals(newItem.getPassword()) || oldItem.getPortNo() != newItem.getPortNo() || !Objects.equals(oldItem.getSecondaryHostname(), newItem.getSecondaryHostname());
    }

    @Override
    public String shutdown() {
        String host = DNSResolverFactory.getInstance().getDefaultHost();
        this.removeItem(host);
        return "== Removing cluster_nodes item: " + host + "\n";
    }

    public void storeItem(ClusterRepoItem item) {
    }

    @Override
    public void initialize() {
        super.initialize();
        TigaseRuntime.getTigaseRuntime().addShutdownHook(this);
    }

    @Override
    public void beforeUnregister() {
        TigaseRuntime.getTigaseRuntime().removeShutdownHook(this);
        super.beforeUnregister();
    }

    protected void removeObsoloteItems(long factor) {
        for (ClusterRepoItem next : this) {
            if (next.getLastUpdate() <= 0L || System.currentTimeMillis() - next.getLastUpdate() <= factor * this.autoReloadInterval) continue;
            this.removeItem(next.getHostname());
        }
    }

    private boolean clusterRecordValid(ClusterRepoItem item) {
        boolean isCorrect;
        boolean bl = isCorrect = !item.getHostname().equalsIgnoreCase("localhost");
        if (!isCorrect && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Incorrect entry in cluster table, skipping: {0}", item);
        }
        return isCorrect;
    }
}

