/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.kernel.beans.Bean;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

@Deprecated
@TigaseDeprecated(since="8.4.0", removeIn="9.0.0", note="SCRAM should be used for maximum security; it's possible to migrate to SCRAM seamlessly")
public class MD5UsernamePasswordCredentialsEntry
implements Credentials.Entry {
    private static final Logger log = Logger.getLogger(MD5UsernamePasswordCredentialsEntry.class.getCanonicalName());
    private final String passwordHash;
    private final BareJID user;

    protected static String getUsername(BareJID user) {
        if (user.getLocalpart() == null) {
            return user.getDomain();
        }
        return user.getLocalpart();
    }

    public MD5UsernamePasswordCredentialsEntry(BareJID user, String passwordHash) {
        this.user = user;
        this.passwordHash = passwordHash;
    }

    @Override
    public String getMechanism() {
        return "MD5-USERNAME-PASSWORD";
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Override
    public boolean verifyPlainPassword(String plain) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest((MD5UsernamePasswordCredentialsEntry.getUsername(this.user) + plain).getBytes(StandardCharsets.UTF_8));
            return this.passwordHash.equalsIgnoreCase(Algorithms.bytesToHex((byte[])hash));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "failed to verify password digest", ex);
            return false;
        }
    }

    @Bean(name="MD5-USERNAME-PASSWORD", parent=CredentialsEncoderBean.class, active=false)
    public static class Encoder
    implements Credentials.Encoder<MD5UsernamePasswordCredentialsEntry> {
        @Override
        public String encode(BareJID user, MD5UsernamePasswordCredentialsEntry entry) {
            return entry.getPasswordHash();
        }

        @Override
        public String encode(BareJID user, String password) {
            try {
                byte[] hash = MessageDigest.getInstance("MD5").digest((MD5UsernamePasswordCredentialsEntry.getUsername(user) + password).getBytes(StandardCharsets.UTF_8));
                return Algorithms.bytesToHex((byte[])hash);
            }
            catch (Exception ex) {
                throw new RuntimeException("failed to generate password hash", ex);
            }
        }

        @Override
        public String getName() {
            return "MD5-USERNAME-PASSWORD";
        }
    }

    @Bean(name="MD5-USERNAME-PASSWORD", parent=CredentialsDecoderBean.class, active=false)
    public static class Decoder
    implements Credentials.Decoder<MD5UsernamePasswordCredentialsEntry> {
        @Override
        public MD5UsernamePasswordCredentialsEntry decode(BareJID user, String value) {
            return new MD5UsernamePasswordCredentialsEntry(user, value);
        }

        @Override
        public String getName() {
            return "MD5-USERNAME-PASSWORD";
        }
    }
}

