/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.PacketWriter;
import tigase.component.responses.AsyncCallback;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.impl.PresenceState;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsTest;
import tigase.xmpp.impl.push.PushPresence;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class PushPresenceTest
extends ProcessorTestCase {
    private RosterAbstract rosterUtil;
    private PushPresence pushPresence;
    private BareJID userJid;
    private BareJID buddyJid;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registerLocalBeans(this.getKernel());
        this.rosterUtil = RosterFactory.newRosterInstance((String)RosterFactory.ROSTER_IMPL_PROP_VAL);
        this.rosterUtil.setEventBus(this.getInstance(EventBus.class));
        this.userJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain.com");
        this.buddyJid = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"domain.com");
        this.pushPresence = this.getInstance(PushPresence.class);
        this.pushPresence.setRosterUtil(this.rosterUtil);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getInstance(PushPresence.class).beforeUnregister();
        super.tearDown();
    }

    @Test
    public void testSendingPresence_OnPushEnable_NoSubscription() throws TigaseStringprepException, TigaseDBException, NotAuthorizedException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(session, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
    }

    @Test
    public void testSendingPresence_OnPushEnable_WithSubscription() throws TigaseStringprepException, TigaseDBException, NotAuthorizedException, PolicyViolationException, NoConnectionIdException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection buddySession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.buddyJid, (String)"setter"));
        XMPPResourceConnection userSession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        this.updateRoster(userSession, JID.jidInstance((BareJID)this.buddyJid), RosterAbstract.SubscriptionType.both);
        this.updateRoster(buddySession, JID.jidInstance((BareJID)this.userJid), RosterAbstract.SubscriptionType.both);
        pushNotifications.enableNotifications(userSession, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceAway(writer.getQueue().poll());
    }

    @Test
    public void testSendingPresence_OnPushDisable_NoSubscription() throws TigaseStringprepException, TigaseDBException, NotAuthorizedException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(session, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
        pushNotifications.disableNotifications(session, this.userJid, JID.jidInstance((String)"push.localhost"), "test-node", writer::write);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
    }

    @Test
    public void testSendingPresence_OnPushDisable_WithSubscription() throws TigaseStringprepException, TigaseDBException, NotAuthorizedException, PolicyViolationException, NoConnectionIdException, InterruptedException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection buddySession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.buddyJid, (String)"setter"));
        XMPPResourceConnection userSession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(userSession, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        this.updateRoster(userSession, JID.jidInstance((BareJID)this.buddyJid), RosterAbstract.SubscriptionType.both);
        this.updateRoster(buddySession, JID.jidInstance((BareJID)this.userJid), RosterAbstract.SubscriptionType.both);
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceAway(writer.getQueue().poll());
        pushNotifications.disableNotifications(userSession, this.userJid, JID.jidInstance((String)"push.localhost"), "test-node", writer::write);
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceUnavailable(writer.getQueue().poll());
    }

    @Test
    public void testSendingPresence_OnPresenceProbe_NoSubscription() throws TigaseStringprepException, TigaseDBException, XMPPException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(session, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
        PresenceState presenceState = this.getInstance(PresenceState.class);
        Packet probe = Packet.packetInstance((Element)new Element("presence").withAttribute("type", StanzaType.probe.name()).withAttribute("from", this.buddyJid.toString()).withAttribute("to", this.userJid.toString()));
        presenceState.process(probe, null, null, writer.getQueue(), new HashMap());
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
    }

    @Test
    public void testSendingPresence_OnSubscriptionAndOnPresenceProbe_WithSubscription() throws TigaseStringprepException, TigaseDBException, XMPPException, PolicyViolationException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection userSession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(userSession, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        XMPPResourceConnection buddySession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.buddyJid, (String)"setter"));
        this.updateRoster(userSession, JID.jidInstance((BareJID)this.buddyJid), RosterAbstract.SubscriptionType.both);
        this.updateRoster(buddySession, JID.jidInstance((BareJID)this.userJid), RosterAbstract.SubscriptionType.both);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceAway(writer.getQueue().poll());
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
        PresenceState presenceState = this.getInstance(PresenceState.class);
        Packet probe = Packet.packetInstance((Element)new Element("presence").withAttribute("type", StanzaType.probe.name()).withAttribute("from", this.buddyJid.toString()).withAttribute("to", this.userJid.toString()));
        presenceState.process(probe, null, null, writer.getQueue(), new HashMap());
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceAway(writer.getQueue().poll());
    }

    @Test
    public void testSendingPresence_OnSubscriptionAndOnRemovingSubscription() throws TigaseStringprepException, TigaseDBException, XMPPException, PolicyViolationException {
        TestPacketWriter writer = this.getInstance(TestPacketWriter.class);
        Assert.assertFalse((boolean)this.pushPresence.isPushAvailable(this.userJid));
        PushNotifications pushNotifications = this.getInstance(PushNotifications.class);
        XMPPResourceConnection userSession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.userJid, (String)"setter"));
        pushNotifications.enableNotifications(userSession, JID.jidInstance((String)"push.localhost"), "test-node", new Element("enable"), null, writer::write);
        XMPPResourceConnection buddySession = this.getSession(JID.jidInstance((String)UUID.randomUUID().toString(), (String)"domain", null), JID.jidInstance((BareJID)this.buddyJid, (String)"setter"));
        this.updateRoster(userSession, JID.jidInstance((BareJID)this.buddyJid), RosterAbstract.SubscriptionType.both);
        this.updateRoster(buddySession, JID.jidInstance((BareJID)this.userJid), RosterAbstract.SubscriptionType.both);
        Assert.assertTrue((boolean)this.pushPresence.isPushAvailable(this.userJid));
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceAway(writer.getQueue().poll());
        Assert.assertEquals((long)0L, (long)writer.getQueue().size());
        this.updateRoster(userSession, JID.jidInstance((BareJID)this.buddyJid), RosterAbstract.SubscriptionType.none);
        this.updateRoster(buddySession, JID.jidInstance((BareJID)this.userJid), RosterAbstract.SubscriptionType.none);
        Assert.assertEquals((long)1L, (long)writer.getQueue().size());
        this.assertPresenceUnavailable(writer.getQueue().poll());
    }

    private void assertPresenceUnavailable(Packet presence) {
        Assert.assertEquals((Object)"presence", (Object)presence.getElemName());
        Assert.assertEquals((Object)StanzaType.unavailable, (Object)presence.getType());
    }

    private void assertPresenceAway(Packet presence) {
        Assert.assertEquals((Object)"presence", (Object)presence.getElemName());
        Assert.assertEquals(null, (Object)presence.getType());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.buddyJid), (Object)presence.getStanzaTo());
        Assert.assertEquals((Object)"xa", (Object)presence.getElemCDataStaticStr(new String[]{"presence", "show"}));
    }

    private void updateRoster(XMPPResourceConnection session, JID buddy, RosterAbstract.SubscriptionType subscriptionType) throws TigaseDBException, NotAuthorizedException, PolicyViolationException, NoConnectionIdException {
        this.rosterUtil.addBuddy(session, buddy, null, null, null);
        this.rosterUtil.setBuddySubscription(session, subscriptionType, buddy);
        Element new_buddy = this.rosterUtil.getBuddyItem(session, buddy);
        this.rosterUtil.updateBuddyChange(session, new ArrayDeque(), new_buddy);
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void registerLocalBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("sess-man").asInstance((Object)this.getSessionManagerHandler()).setActive(true).exportable().exec();
        kernel.registerBean(MessageDeliveryLogic.class).setActive(true).exportable().exec();
        kernel.registerBean("msgRepository").asClass(PushNotificationsTest.MsgRepositoryIfcImpl.class).exportable().exec();
        kernel.registerBean(PushNotifications.class).setActive(true).exec();
        kernel.registerBean("writer").asInstance((Object)new TestPacketWriter()).exec();
        kernel.registerBean(PushPresence.class).setActive(true).exec();
        kernel.registerBean(PresenceState.class).setActive(true).exec();
    }

    protected static class TestPacketWriter
    implements PacketWriter {
        private final ArrayDeque<Packet> queue = new ArrayDeque();

        public synchronized void write(Collection<Packet> packets) {
            this.queue.addAll(packets);
        }

        public synchronized void write(Packet packet) {
            this.queue.add(packet);
        }

        public synchronized void write(Packet packet, AsyncCallback callback) {
            this.queue.add(packet);
        }

        public synchronized ArrayDeque<Packet> getQueue() {
            return this.queue;
        }
    }
}

