/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import tigase.xmpp.impl.push.EncryptedPushNotificationExtension;

public class EncryptedPushNotificationExtensionTest {
    @Test
    public void testMessageBodyTruncation() {
        int i;
        int maxSize = 3000;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 1000; ++i) {
            sb.append("\ud83d\ude21");
        }
        for (i = 0; i < 7936; ++i) {
            if (i % 10 == 0) {
                sb.append("\ud83d\ude21");
                continue;
            }
            sb.append(String.valueOf(i % 10));
        }
        String origBody = sb.toString();
        String body = EncryptedPushNotificationExtension.trimBodyToSize((int)maxSize, (String)origBody);
        Assert.assertTrue((body.getBytes(StandardCharsets.UTF_8).length <= 3000 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)origBody.contains(body));
    }

    @Test
    public void testMessageBodyTruncation1() {
        this.runCharTest(1, "\u0800", 2999);
    }

    @Test
    public void testMessageBodyTruncation2() {
        this.runCharTest(2, "\ud83d\udc75\ud83c\udffb", 2999);
    }

    @Test
    public void testMessageBodyTruncation3() {
        this.runCharTest(3, "\ud83d\ude21", 2999);
    }

    @Test
    public void testMessageBodyTruncation4() {
        this.runCharTest(4, "\u07df", 2999);
    }

    @Test
    public void testMessageBodyTruncation5() {
        this.runCharTest(5, "\ufffd", 2999);
    }

    @Test
    public void testJsonEncoding() {
        String body = "To be, \\ or \"not\" to \b\t\r be:\n that is / the question";
        StringBuilder sb = new StringBuilder();
        EncryptedPushNotificationExtension.valueToString((Object)body, (StringBuilder)sb);
        Assert.assertEquals((Object)"\"To be, \\\\ or \\\"not\\\" to \\b\\t\\r be:\\n that is \\/ the question\"", (Object)sb.toString());
    }

    private void runCharTest(int tryNo, String ch, int maxSize) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5000; ++i) {
            sb.append(ch);
        }
        String origBody = sb.toString();
        String body = EncryptedPushNotificationExtension.trimBodyToSize((int)maxSize, (String)origBody);
        Assert.assertTrue((body.getBytes(StandardCharsets.UTF_8).length <= 3000 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)origBody.contains(body));
    }
}

