/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.annotation;

import org.junit.Assert;
import org.junit.Test;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SessionBind;
import tigase.xmpp.impl.annotation.TestAnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.TestAnnotatedXMPPProcessor2;

public class AnnotatedXMPPProcessorTest {
    @Test
    public void test1() {
        TestAnnotatedXMPPProcessor test1 = new TestAnnotatedXMPPProcessor();
        for (Object[] objectArray : test1.supElementNamePaths()) {
            Assert.assertArrayEquals((String)"Wrong element paths", (Object[])new String[]{"iq", "query"}, (Object[])objectArray);
        }
        Assert.assertArrayEquals((String)"Wrong xmlnss", (Object[])new String[]{"tigase:test1", "tigase:test2"}, (Object[])test1.supNamespaces());
        Assert.assertArrayEquals((String)"Wrong disco features", (Object[])new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:test1"}), new Element("feature", new String[]{"var"}, new String[]{"tigase:test2"})}, (Object[])test1.supDiscoFeatures(null));
        Assert.assertArrayEquals((String)"Wrong stream features", (Object[])new Element[]{new Element("bind", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})}, (Object[])test1.supStreamFeatures(null));
        Assert.assertTrue((String)"Stanza type not set as 'get'", (boolean)test1.supTypes().contains(StanzaType.get));
    }

    @Test
    public void test2() {
        TestAnnotatedXMPPProcessor2 test2 = new TestAnnotatedXMPPProcessor2();
        Assert.assertNull((String)"Wrong element paths, should not be inherited", (Object)test2.supElementNamePaths());
        Assert.assertNull((String)"Wrong xmlnss", (Object)test2.supNamespaces());
        Assert.assertNull((String)"Wrong disco features", (Object)test2.supDiscoFeatures(null));
        Assert.assertNull((String)"Wrong stream features", (Object)test2.supStreamFeatures(null));
    }

    @Test
    public void testSessionBind() throws NotAuthorizedException, TigaseStringprepException {
        SessionBind sessionBind = new SessionBind();
        Assert.assertEquals((String)"Wrong processor id", (Object)"urn:ietf:params:xml:ns:xmpp-session", (Object)sessionBind.id());
        for (Object[] objectArray : sessionBind.supElementNamePaths()) {
            Assert.assertArrayEquals((String)"Wrong element paths", (Object[])new String[]{"iq", "session"}, (Object[])objectArray);
        }
        Assert.assertArrayEquals((String)"Wrong xmlnss", (Object[])new String[]{"urn:ietf:params:xml:ns:xmpp-session"}, (Object[])sessionBind.supNamespaces());
        Assert.assertArrayEquals((String)"Wrong disco features", (Object[])new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"})}, (Object[])sessionBind.supDiscoFeatures(null));
        XMPPResourceConnection session = this.getSession();
        Element xmppSession = new Element("session");
        xmppSession.setXMLNS("urn:ietf:params:xml:ns:xmpp-session");
        xmppSession.addChild((XMLNodeIfc)new Element("optional"));
        Assert.assertArrayEquals((String)"Lack optional child", (Object[])new Element[]{xmppSession}, (Object[])sessionBind.supStreamFeatures(session));
        session.putSessionData("Session-Set", (Object)"true");
        Assert.assertArrayEquals((String)"Lack optional child", null, (Object[])sessionBind.supStreamFeatures(session));
    }

    private XMPPResourceConnection getSession() throws NotAuthorizedException, TigaseStringprepException {
        XMPPResourceConnection conn = new XMPPResourceConnection(this, null, null, null, null){

            public boolean isAuthorized() {
                return true;
            }
        };
        return conn;
    }
}

