/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBusFactory;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MIXProcessor;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MIXProcessorTest
extends ProcessorTestCase {
    private JID mixChannel;
    private XMPPResourceConnection session;
    private JID user;

    @Test
    public void canHandleRetractedParticipantEvent() throws TigaseStringprepException {
        Packet packet = this.getRetractedParticipantMessage(this.mixChannel.getBareJID(), this.user.getBareJID());
        MIXProcessor mixProcessor = (MIXProcessor)this.getKernel().getInstance(MIXProcessor.class);
        TestCase.assertEquals((Object)Authorization.AUTHORIZED, (Object)mixProcessor.canHandle(packet, this.session));
    }

    private Packet getRetractedParticipantMessage(BareJID fromMixChannel, BareJID toUser) throws TigaseStringprepException {
        Element messageElement = new Element("message", new String[]{"xmlns", "from", "to"}, new String[]{"jabber:client", fromMixChannel.toString(), toUser.toString()});
        Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
        Element items = new Element("items", new String[]{"node"}, new String[]{"urn:xmpp:mix:nodes:participants"});
        Element retracted = new Element("retract");
        retracted.addAttribute("id", MIXProcessor.generateParticipantId((BareJID)fromMixChannel, (BareJID)toUser));
        items.addChild((XMLNodeIfc)retracted);
        event.addChild((XMLNodeIfc)items);
        messageElement.addChild((XMLNodeIfc)event);
        Packet packet = Message.packetInstance((Element)messageElement);
        packet.setPacketFrom(this.mixChannel);
        return packet;
    }

    @Before
    public void prepare() throws TigaseStringprepException, NotAuthorizedException {
        this.getKernel().registerBean("eventbus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        this.getKernel().registerBean("sess-man").asInstance((Object)new SessionManager()).setActive(true).exportable().exec();
        this.getKernel().registerBean(RosterFactory.Bean.class).setActive(true).exec();
        this.getKernel().getInstance(RosterFactory.Bean.class);
        this.getKernel().registerBean(MIXProcessor.class).setActive(true).exec();
        this.mixChannel = JID.jidInstance((String)"d6af5eea-ccc2-4b94-8402-387fee89ece9@mix.domain.com");
        this.user = JID.jidInstance((String)"user1@example.com/res1");
        this.session = this.getSession(this.user, this.user, true);
    }

    @Test
    public void testNotRemoveMixChannelFromRosterOnUserRetractedEventNotMatchingId() throws TigaseStringprepException, XMPPException, TigaseDBException, PolicyViolationException {
        RosterAbstract rosterUtil = RosterFactory.getRosterImplementation((boolean)true);
        RosterElement mixChannelRosterElement = new RosterElement(this.mixChannel, this.mixChannel.toString(), null);
        rosterUtil.addJidToRoster(this.getUserRepository(), this.session.getParentSession(), this.user.getBareJID(), mixChannelRosterElement);
        List rosterItems = rosterUtil.getRosterItems(this.session);
        Assert.assertFalse((boolean)rosterItems.isEmpty());
        Element mixRosterItem = rosterUtil.getBuddyItem(this.session, this.mixChannel);
        Assert.assertNotNull((Object)mixRosterItem);
        MIXProcessor processor = (MIXProcessor)this.getKernel().getInstance(MIXProcessor.class);
        JID otherUser = JID.jidInstance((String)"user2@example.com/res2");
        Packet packet = this.getRetractedParticipantMessage(this.mixChannel.getBareJID(), otherUser.getBareJID());
        ArrayDeque results = new ArrayDeque();
        processor.process(packet, this.session, null, results, Map.of());
        TestCase.assertEquals((int)0, (int)results.size());
        List rosterItemsAfterProcessing = rosterUtil.getRosterItems(this.session);
        Assert.assertFalse((boolean)rosterItemsAfterProcessing.isEmpty());
        Element mixRosterItemAfterProcessing = rosterUtil.getBuddyItem(this.session, this.mixChannel);
        Assert.assertNotNull((Object)mixRosterItemAfterProcessing);
    }

    @Test
    public void testRemoveMixChannelFromRosterOnUserRetractedEventMatchingId() throws TigaseStringprepException, XMPPException, TigaseDBException, PolicyViolationException {
        RosterAbstract rosterUtil = RosterFactory.getRosterImplementation((boolean)true);
        RosterElement mixChannelRosterElement = new RosterElement(this.mixChannel, this.mixChannel.toString(), null);
        rosterUtil.addJidToRoster(this.getUserRepository(), this.session.getParentSession(), this.user.getBareJID(), mixChannelRosterElement);
        List rosterItems = rosterUtil.getRosterItems(this.session);
        Assert.assertFalse((boolean)rosterItems.isEmpty());
        Element mixRosterItem = rosterUtil.getBuddyItem(this.session, this.mixChannel);
        Assert.assertNotNull((Object)mixRosterItem);
        MIXProcessor processor = (MIXProcessor)this.getKernel().getInstance(MIXProcessor.class);
        Packet packet = this.getRetractedParticipantMessage(this.mixChannel.getBareJID(), this.user.getBareJID());
        ArrayDeque results = new ArrayDeque();
        processor.process(packet, this.session, null, results, Map.of());
        TestCase.assertEquals((int)1, (int)results.size());
        Element rosterElement = ((Packet)results.getFirst()).getElement();
        TestCase.assertEquals((String)"jabber:iq:roster", (String)rosterElement.getChild("query").getXMLNS());
        TestCase.assertEquals((String)"remove", (String)rosterElement.getChild("query").getChild("item").getAttributeStaticStr("subscription"));
        List rosterItemsAfterProcessing = rosterUtil.getRosterItems(this.session);
        Assert.assertTrue((boolean)rosterItemsAfterProcessing.isEmpty());
        Element mixRosterItemAfterProcessing = rosterUtil.getBuddyItem(this.session, this.mixChannel);
        Assert.assertNull((Object)mixRosterItemAfterProcessing);
    }

    @Test
    public void testSha() throws RepositoryException {
        this.mixChannel = JID.jidInstanceNS((String)"3dc9222b-3316-41f6-927f-fb7f7dd4ad1f@mix.atlantiscity");
        this.user = JID.jidInstanceNS((String)"tigase3@atlantiscity/atlantiscity");
        String participantId = MIXProcessor.generateParticipantId((BareJID)this.mixChannel.getBareJID(), (BareJID)this.user.getBareJID());
        TestCase.assertEquals((String)"318cd48257571b007eb68d759f9c59a3736a1584", (String)participantId);
    }
}

