/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.util.repository.DataTypes;

public class DataTypesTest {
    private static final Logger log = TestLogger.getLogger(DataTypesTest.class);

    @Test
    public void testParseNum() {
        Assert.assertEquals((Object)new Long(262144L), (Object)((Integer)Integer.class.cast(DataTypes.parseNum((String)"256k", Integer.class, (Number)1))));
        Assert.assertEquals((Object)new Long(262144L), Long.class.cast(DataTypes.parseNum((String)"256k", Long.class, (Number)1L)));
        Assert.assertEquals((Object)new Double(670720.0), Double.class.cast(DataTypes.parseNum((String)"655k", Double.class, (Number)1.0)));
        Assert.assertEquals((Object)new Double(262144.0), (Object)((Float)Float.class.cast(DataTypes.parseNum((String)"256k", Float.class, (Number)Float.valueOf(1.0f)))).floatValue());
        Assert.assertEquals((Object)new Long(25L), (Object)((Short)DataTypes.parseNum((String)"25", Short.class, (Number)Short.valueOf("1"))));
        Assert.assertEquals((Object)new Long(25L), (Object)((Byte)Byte.class.cast(DataTypes.parseNum((String)"25", Byte.class, (Number)Byte.valueOf("1")))));
    }

    @Test
    public void testParseSizeInt() {
        log.log(Level.FINE, "parseSizeInt");
        Assert.assertEquals((long)1L, (long)DataTypes.parseSizeInt((String)"1", (int)1));
        Assert.assertEquals((long)1024L, (long)DataTypes.parseSizeInt((String)"1k", (int)1));
        Assert.assertEquals((long)0x100000L, (long)DataTypes.parseSizeInt((String)"1m", (int)1));
        Assert.assertEquals((long)0x40000000L, (long)DataTypes.parseSizeInt((String)"1g", (int)1));
        Assert.assertEquals((long)1L, (long)DataTypes.parseSizeInt((String)"fail", (int)1));
    }

    @Test
    public void testNull() {
        Object o = DataTypes.decodeValueType((char)'S', (String)"null");
        Assert.assertNull((Object)o);
    }
}

