/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tigase.TestLogger;
import tigase.conf.ConfigReader;
import tigase.db.AuthRepositoryMDImpl;
import tigase.db.UserRepositoryMDImpl;
import tigase.kernel.core.Kernel;
import tigase.server.BasicComponent;
import tigase.server.Bootstrap;
import tigase.server.CmdAcl;
import tigase.server.MessageRouter;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppsession.SessionManager;

@Ignore
public class BootstrapTest {
    private static final Logger log = TestLogger.getLogger(BootstrapTest.class);
    private Map<String, Object> props = new HashMap<String, Object>();

    @Test
    public void testNonCluster() throws InterruptedException, ConfigReader.ConfigException {
        this.props.put("cluster-mode", "false");
        Bootstrap bootstrap = this.executeTest();
        Thread.sleep(600000L);
        bootstrap.stop();
    }

    @Test
    public void testCluster() throws ConfigReader.ConfigException {
        this.props.put("cluster-mode", "true");
        Bootstrap bootstrap = this.executeTest();
        bootstrap.stop();
    }

    public Bootstrap executeTest() throws ConfigReader.ConfigException {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.setProperties(this.getProps());
        bootstrap.start();
        Kernel kernel = bootstrap.getKernel();
        Assert.assertNotNull((Object)kernel);
        MessageRouter mr = (MessageRouter)kernel.getInstance("message-router");
        ClientConnectionManager c2s = (ClientConnectionManager)kernel.getInstance("c2s");
        S2SConnectionManager s2s = (S2SConnectionManager)kernel.getInstance("s2s");
        UserRepositoryMDImpl userRepository = (UserRepositoryMDImpl)kernel.getInstance("userRepository");
        AuthRepositoryMDImpl authRepository = (AuthRepositoryMDImpl)kernel.getInstance("authRepository");
        Assert.assertNotNull((Object)mr);
        Assert.assertNotNull((Object)c2s);
        Assert.assertNotNull((Object)s2s);
        Assert.assertNotNull((Object)userRepository);
        Assert.assertNotNull((Object)userRepository.getRepo(null));
        Assert.assertNotNull((Object)authRepository);
        Assert.assertNotNull((Object)authRepository.getRepo("default"));
        this.assertCommandACL(kernel, "ala-ma-kota", new CmdAcl("LOCAL"));
        this.assertCommandACL(kernel, "ala-ma-kota1", new CmdAcl("test.com"));
        this.assertCommandACL(kernel, "ala-ma-kota2", new CmdAcl("ala@test.com"));
        return bootstrap;
    }

    public Map<String, Object> getProps() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.props);
        props.put("dataSource/repo-uri", "jdbc:postgresql://127.0.0.1/tigase?user=test&password=test&autoCreateUser=true");
        props.put("sess-man/commands/ala-ma-kota", "LOCAL");
        props.put("sess-man/commands/ala-ma-kota1", "test.com");
        props.put("sess-man/commands/ala-ma-kota2", "ala@test.com");
        props.put("c2s/incoming-filters", "tigase.server.filters.PacketCounter,tigase.server.filters.PacketCounter");
        return props;
    }

    private void assertCommandACL(Kernel kernel, String cmdId, CmdAcl expectedAcl) {
        try {
            SessionManager sm = (SessionManager)kernel.getInstance(SessionManager.class);
            Field commandsAcl = BasicComponent.class.getDeclaredField("commandsACL");
            commandsAcl.setAccessible(true);
            Map val = (Map)commandsAcl.get(sm);
            log.log(Level.FINE, "ACL = " + String.valueOf(val));
            Set acl = (Set)val.get(cmdId);
            Assert.assertTrue((boolean)acl.stream().filter(a -> a.equals((Object)expectedAcl)).findAny().isPresent());
            log.log(Level.FINE, String.valueOf(acl.getClass()) + ", " + String.valueOf(acl));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

