/*
 * Decompiled with CFR 0.152.
 */
package tigase.map;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import tigase.eventbus.EventBus;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.map.ClusterMapFactory;
import tigase.map.DMap;
import tigase.map.MapCreatedEvent;
import tigase.map.MapDestroyedEvent;

public class ClusterMapFactoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateMap() throws Exception {
        Object mutex = new Object();
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        Object[] createdEvent = new Object[]{null};
        eventBus.addListener(ClusterMapFactory.NewMapCreatedEvent.class, event -> {
            Assert.assertNull((Object)createdEvent[0]);
            createdEvent[0] = event;
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        });
        Map map = factory.createMap("test", String.class, String.class, new String[]{"1", "2", "3"});
        Object object = mutex;
        synchronized (object) {
            mutex.wait(10000L);
        }
        Assert.assertNotNull((Object)createdEvent[0]);
        Assert.assertNotNull((Object)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDestroyMap() throws Exception {
        Object mutex = new Object();
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        Object[] destroyedEvent = new Object[]{null};
        eventBus.addListener(ClusterMapFactory.MapDestroyEvent.class, event -> {
            Assert.assertNull((Object)destroyedEvent[0]);
            destroyedEvent[0] = event;
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        });
        Map map = factory.createMap("test2", String.class, String.class, new String[]{"1", "2", "3"});
        factory.destroyMap(map);
        Object object = mutex;
        synchronized (object) {
            mutex.wait(10000L);
        }
        Assert.assertNotNull((String)"MapDestroyEvent not received", (Object)destroyedEvent[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutToMap() throws Exception {
        Object mutex = new Object();
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        boolean[] received = new boolean[]{false};
        Map map = factory.createMap("test", String.class, String.class, new String[0]);
        eventBus.addListener(ClusterMapFactory.ElementAddEvent.class, event -> {
            received[0] = true;
            Assert.assertEquals((Object)"kluczyk", (Object)event.getKey());
            Assert.assertEquals((Object)"wartosc", (Object)event.getValue());
            Assert.assertEquals((Object)((DMap)map).getUid(), (Object)event.getUid());
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        });
        map.put("kluczyk", "wartosc");
        Object object = mutex;
        synchronized (object) {
            mutex.wait(10000L);
        }
        Assert.assertTrue((boolean)received[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteCreatedMap() throws Exception {
        Object mutex = new Object();
        ClusterMapFactory.NewMapCreatedEvent eventCreate = new ClusterMapFactory.NewMapCreatedEvent();
        eventCreate.setUid("test");
        eventCreate.setKeyClass(String.class);
        eventCreate.setValueClass(String.class);
        eventCreate.setParams(new String[]{"1", "2"});
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        Map[] maps = new Map[]{null};
        eventBus.addListener(MapCreatedEvent.class, e -> {
            maps[0] = e.getMap();
            Assert.assertEquals((Object)"test", (Object)e.getUid());
            Assert.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])e.getParameters());
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        });
        factory.onNewMapCreated(eventCreate);
        Object object = mutex;
        synchronized (object) {
            mutex.wait(10000L);
        }
        Assert.assertNotNull((String)"It seems map was not created", (Object)maps[0]);
        Assert.assertEquals((Object)"test", (Object)((DMap)maps[0]).uid);
        ClusterMapFactory.ElementAddEvent eventAdd = new ClusterMapFactory.ElementAddEvent();
        eventAdd.setUid("test");
        eventAdd.setKey("xKEY");
        eventAdd.setValue("xVALUE");
        factory.onMapElementAdd(eventAdd);
        eventAdd = new ClusterMapFactory.ElementAddEvent();
        eventAdd.setUid("test");
        eventAdd.setKey("yKEY");
        eventAdd.setValue("yVALUE");
        factory.onMapElementAdd(eventAdd);
        Assert.assertEquals((Object)"xVALUE", maps[0].get("xKEY"));
        Assert.assertEquals((Object)"yVALUE", maps[0].get("yKEY"));
        Assert.assertEquals((long)2L, (long)maps[0].size());
        ClusterMapFactory.ElementRemoveEvent eventDel = new ClusterMapFactory.ElementRemoveEvent();
        eventDel.setUid("test");
        eventDel.setKey("xKEY");
        factory.onMapElementRemove(eventDel);
        Assert.assertNull(maps[0].get("xKEY"));
        Assert.assertEquals((long)1L, (long)maps[0].size());
        ClusterMapFactory.MapClearEvent eventClear = new ClusterMapFactory.MapClearEvent();
        eventClear.setUid("test");
        factory.onMapClear(eventClear);
        Assert.assertEquals((long)0L, (long)maps[0].size());
        boolean[] received = new boolean[]{false};
        eventBus.addListener(MapDestroyedEvent.class, event -> {
            Assert.assertEquals((Object)maps[0], (Object)event.getMap());
            received[0] = true;
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        });
        Assert.assertNotNull((Object)factory.getMap("test"));
        ClusterMapFactory.MapDestroyEvent eventDestroy = new ClusterMapFactory.MapDestroyEvent();
        eventDestroy.setUid("test");
        factory.onMapDestroyed(eventDestroy);
        Assert.assertNull((Object)factory.getMap("test"));
        Object object2 = mutex;
        synchronized (object2) {
            mutex.wait(10000L);
        }
        Assert.assertTrue((boolean)received[0]);
    }
}

