/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import tigase.cluster.ClientConnectionClustered;
import tigase.cluster.SessionManagerClustered;
import tigase.cluster.strategy.DefaultClusteringStrategy;
import tigase.conf.ConfigHelper;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.server.xmppclient.ClientConnectionManager;

public class ConfigHelperTest {
    @Test
    public void test_merge() {
        HashMap<String, String> prop1 = new HashMap<String, String>();
        prop1.put("test1", "123");
        prop1.put("test2", "456");
        AbstractBeanConfigurator.BeanDefinition bean1 = new AbstractBeanConfigurator.BeanDefinition();
        bean1.setBeanName("sess-man");
        bean1.setClazzName(SessionManagerClustered.class.getCanonicalName());
        bean1.setActive(true);
        bean1.put((Object)"plugins", Arrays.asList("jabber:iq:register", "urn:ietf:params:xml:ns:xmpp-sasl"));
        bean1.computeIfAbsent((Object)"map", o -> {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("left", "right");
            return tmp;
        });
        bean1.computeIfAbsent((Object)"strategy", name -> {
            AbstractBeanConfigurator.BeanDefinition strategyBean = new AbstractBeanConfigurator.BeanDefinition();
            strategyBean.setBeanName((String)name);
            strategyBean.setClazzName(DefaultClusteringStrategy.class.getCanonicalName());
            strategyBean.setActive(true);
            strategyBean.put((Object)"force", (Object)true);
            return strategyBean;
        });
        prop1.put(bean1.getBeanName(), (String)bean1);
        AbstractBeanConfigurator.BeanDefinition bean2 = new AbstractBeanConfigurator.BeanDefinition();
        bean2.setBeanName("c2s");
        bean2.setClazzName(ClientConnectionManager.class.getCanonicalName());
        bean2.setActive(true);
        bean2.put((Object)"processors", Arrays.asList("urn:xmpp:sm:3"));
        prop1.put(bean2.getBeanName(), (String)bean2);
        HashMap<String, Object> prop2 = new HashMap<String, Object>();
        prop2.put("test3", 789);
        prop2.computeIfAbsent("sess-man", s -> {
            HashMap<String, Object> sessMan = new HashMap<String, Object>();
            sessMan.put("plugins", Arrays.asList("presence-state", "presence-subscription"));
            sessMan.computeIfAbsent("map", o -> {
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("up", "down");
                return tmp;
            });
            sessMan.computeIfAbsent("strategy", name -> {
                HashMap<String, Boolean> sMap = new HashMap<String, Boolean>();
                sMap.put("force", false);
                return sMap;
            });
            return sessMan;
        });
        AbstractBeanConfigurator.BeanDefinition bean3 = new AbstractBeanConfigurator.BeanDefinition();
        bean3.setBeanName("c2s");
        bean3.setClazzName(ClientConnectionClustered.class.getCanonicalName());
        bean3.setActive(true);
        bean3.put((Object)"test4", (Object)987);
        prop2.put(bean3.getBeanName(), bean3);
        Map result = ConfigHelper.merge((Map[])new Map[]{prop1, prop2});
        Assert.assertEquals((Object)"123", result.get("test1"));
        Assert.assertEquals((Object)"456", result.get("test2"));
        AbstractBeanConfigurator.BeanDefinition bean1a = (AbstractBeanConfigurator.BeanDefinition)result.get(bean1.getBeanName());
        Assert.assertEquals((Object)bean1.getClazzName(), (Object)bean1a.getClazzName());
        Assert.assertEquals((Object)bean1.isActive(), (Object)bean1a.isActive());
        Assert.assertEquals(((Map)prop2.get("sess-man")).get("plugins"), (Object)bean1a.get((Object)"plugins"));
        Assert.assertEquals((Object)"right", ((Map)bean1a.get((Object)"map")).get("left"));
        Assert.assertEquals((Object)"down", ((Map)bean1a.get((Object)"map")).get("up"));
        AbstractBeanConfigurator.BeanDefinition sBean = (AbstractBeanConfigurator.BeanDefinition)bean1a.get((Object)"strategy");
        Assert.assertEquals((Object)DefaultClusteringStrategy.class.getCanonicalName(), (Object)sBean.getClazzName());
        Assert.assertFalse((boolean)((Boolean)sBean.get((Object)"force")));
        AbstractBeanConfigurator.BeanDefinition bean2a = (AbstractBeanConfigurator.BeanDefinition)result.get(bean2.getBeanName());
        Assert.assertEquals((Object)bean3.getClazzName(), (Object)bean2a.getClazzName());
        Assert.assertEquals((Object)bean3.isActive(), (Object)bean2a.isActive());
        Assert.assertEquals((Object)987, (Object)bean2a.get((Object)"test4"));
        Assert.assertNull((Object)bean2a.get((Object)"test3"));
    }
}

