/*
 * Tigase XMPP Server - The instant messaging server
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.eventbus.impl;

import tigase.eventbus.HandleEvent;

import java.lang.reflect.Method;

public class ReflectEventListenerHandler
		extends AbstractHandler {

	protected final Object consumerObject;
	protected final HandleEvent.Type filter;
	protected final Method handlerMethod;
	protected final boolean synchronous;

	public ReflectEventListenerHandler(HandleEvent.Type filter, final String packageName, final String eventName,
									   Object consumerObject, Method handlerMethod) {
		this(filter, false, packageName, eventName, consumerObject, handlerMethod);
	}

	public ReflectEventListenerHandler(HandleEvent.Type filter, boolean synchronous, final String packageName, final String eventName,
									   Object consumerObject, Method handlerMethod) {
		super(packageName, eventName);
		this.synchronous = synchronous;
		this.filter = filter;
		this.consumerObject = consumerObject;
		this.handlerMethod = handlerMethod;
	}

	@Override
	public void dispatch(final Object event, final Object source, boolean remotelyGeneratedEvent) {
		if (remotelyGeneratedEvent && filter == HandleEvent.Type.local ||
				!remotelyGeneratedEvent && filter == HandleEvent.Type.remote) {
			return;
		}
		try {
			handlerMethod.invoke(consumerObject, event);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		ReflectEventListenerHandler that = (ReflectEventListenerHandler) o;

		if (!consumerObject.equals(that.consumerObject)) {
			return false;
		}
		return handlerMethod.equals(that.handlerMethod);

	}

	@Override
	public Type getRequiredEventType() {
		return Type.object;
	}

	@Override
	public boolean isSynchronous() {
		return synchronous;
	}

	@Override
	public int hashCode() {
		int result = consumerObject.hashCode();
		result = 31 * result + handlerMethod.hashCode();
		return result;
	}

}
