/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.Optional;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.jid.BareJID;

@Bean(name="meet", parent=PushNotifications.class, active=true)
public class MeetPushNotificationExtension
implements PushNotificationsExtension,
PushNotificationsFilter {
    @ConfigField(desc="Always enable", alias="push-meet-always-enabled")
    private boolean alwaysEnabled = false;

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        Element meet = enableEl.getChild("meet", "tigase:push:meet:0");
        if (meet != null) {
            settingsEl.addChild((XMLNodeIfc)meet);
        }
    }

    @Override
    public void prepareNotificationPayload(Element pushServiceSettings, Packet packet, long msgCount, Element notification) {
        if (packet == null || packet.getElemName() != "message") {
            return;
        }
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "tigase:meet:0");
        if (actionEl == null) {
            return;
        }
        String id = actionEl.getAttributeStaticStr("id");
        if (id == null) {
            return;
        }
        String jid = actionEl.getAttributeStaticStr("jid");
        if (jid == null) {
            return;
        }
        notification.withElement("meet", "tigase:push:meet:0", meet -> {
            meet.addAttribute("id", id);
            meet.addAttribute("jid", jid);
            Optional.ofNullable(actionEl.mapChildren(el -> el.getName() == "media", el -> el.getAttributeStaticStr("type"))).ifPresent(mediaTypes -> mediaTypes.forEach(media -> meet.withElement("media", null, media)));
        });
    }

    @Override
    public boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) throws XMPPException {
        if (packet.getElemName() != "message") {
            return false;
        }
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "tigase:meet:0");
        if (actionEl == null || actionEl.getAttributeStaticStr("id") == null) {
            return false;
        }
        switch (actionEl.getName()) {
            case "propose": {
                return packet.getStanzaFrom() != null && !packet.getStanzaFrom().getBareJID().equals((Object)userJid);
            }
        }
        return false;
    }

    @Override
    public boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "tigase:meet:0");
        if (actionEl == null) {
            return true;
        }
        if (this.alwaysEnabled) {
            return true;
        }
        Element meet = pushServiceSettings.getChild("meet", "tigase:push:meet:0");
        return meet != null;
    }
}

