/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.Objects;
import java.util.Optional;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.EncryptedPushNotificationExtension;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsAware;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.jid.BareJID;

@Bean(name="jingle", parent=PushNotifications.class, active=true)
public class JinglePushNotificationsExtension
implements PushNotificationsExtension,
PushNotificationsFilter,
PushNotificationsAware {
    private static final Element[] FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:push:jingle:0"})};
    @Inject
    private EncryptedPushNotificationExtension encryptedPushNotificationExtension;
    @ConfigField(desc="Always enable", alias="push-jingle-always-enabled")
    private boolean alwaysEnabled = false;

    @Override
    public Element[] getDiscoFeatures() {
        return FEATURES;
    }

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        Element jingle = enableEl.getChild("jingle", "tigase:push:jingle:0");
        if (jingle != null) {
            settingsEl.addChild((XMLNodeIfc)jingle);
        }
    }

    @Override
    public void prepareNotificationPayload(Element pushServiceSettings, Packet packet, long msgCount, Element notification) {
        if (packet == null || packet.getElemName() != "message") {
            return;
        }
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "urn:xmpp:jingle-message:0");
        if (actionEl == null) {
            return;
        }
        String id = actionEl.getAttributeStaticStr("id");
        if (id == null) {
            return;
        }
        notification.withElement("jingle", "tigase:push:jingle:0", jingle -> {
            jingle.addAttribute("action", actionEl.getName());
            jingle.addAttribute("sid", id);
            Optional.ofNullable(actionEl.mapChildren(el -> Objects.equals(el.getName(), "description") && Objects.equals(el.getXMLNS(), "urn:xmpp:jingle:apps:rtp:1"), el -> el.getAttributeStaticStr("media"))).ifPresent(mediaTypes -> mediaTypes.forEach(media -> jingle.withElement("media", null, media)));
        });
    }

    @Override
    public boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) throws XMPPException {
        if (packet.getElemName() != "message") {
            return false;
        }
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "urn:xmpp:jingle-message:0");
        if (actionEl == null || actionEl.getAttributeStaticStr("id") == null) {
            return false;
        }
        switch (actionEl.getName()) {
            case "retract": {
                return false;
            }
            case "propose": {
                return packet.getStanzaFrom() != null && !packet.getStanzaFrom().getBareJID().equals((Object)userJid);
            }
        }
        return packet.getStanzaFrom() != null && session != null && session.isUserId(packet.getStanzaFrom().getBareJID());
    }

    @Override
    public boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "urn:xmpp:jingle-message:0");
        if (actionEl == null) {
            return true;
        }
        if (this.alwaysEnabled) {
            return true;
        }
        Element jingle = pushServiceSettings.getChild("jingle", "tigase:push:jingle:0");
        return jingle != null;
    }
}

