/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tigase.kernel.beans.Bean;
import tigase.util.Base64;
import tigase.vhosts.VHostItem;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqRegister;

@Bean(name="CaptchaProvider", parent=JabberIqRegister.class, active=true)
public class CaptchaProvider {
    private Random random = new SecureRandom();

    public CaptchaItem generateCaptcha(XMPPResourceConnection connection) {
        return new SimpleTextCaptcha(this.random, connection);
    }

    public CaptchaItem getCaptchaByID(String id) {
        if (id == null) {
            return null;
        }
        try {
            String[] parts = id.split("\\.");
            String type = parts[0];
            if (!"simple-text".equals(type)) {
                return null;
            }
            return new SimpleTextCaptcha(parts);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static class SimpleTextCaptcha
    implements CaptchaItem {
        private static final Duration TIMEOUT = Duration.ofMinutes(5L);
        private static final int NONCE_LENGTH = 16;
        private final int a;
        private final int b;
        private final int result;
        private final byte[] nonce;
        private final long time;
        private final byte[] hmac;
        private int errorCounter;
        private final Duration timeout = TIMEOUT;

        public static byte[] calculateHMac(byte[] data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            return SimpleTextCaptcha.calculateHMac(data, secretKeySpec);
        }

        public static byte[] calculateHMac(byte[] data, SecretKeySpec secretKeySpec) throws NoSuchAlgorithmException, InvalidKeyException {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            return mac.doFinal(data);
        }

        public static String getSecret(XMPPResourceConnection connection) {
            return Optional.ofNullable(connection.getDomain().getS2sSecret()).orElse(connection.getDomainAsJID().toString());
        }

        public static String getSecret(VHostItem item, String domain) {
            return Optional.ofNullable(item).map(VHostItem::getS2sSecret).orElse(domain);
        }

        SimpleTextCaptcha(Random random, XMPPResourceConnection connection) {
            this(random, () -> {
                String secret = SimpleTextCaptcha.getSecret(connection);
                return new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            });
        }

        public SimpleTextCaptcha(Random random, Supplier<SecretKeySpec> secretSupplier) {
            this.a = 1 + random.nextInt(31);
            this.b = 1 + random.nextInt(31);
            this.result = this.a + this.b;
            this.nonce = new byte[16];
            random.nextBytes(this.nonce);
            this.time = System.currentTimeMillis();
            try {
                this.hmac = SimpleTextCaptcha.calculateHMac((this.getPrefix() + "." + this.result).getBytes(StandardCharsets.UTF_8), secretSupplier.get());
            }
            catch (Throwable ex) {
                throw new RuntimeException("Could not generate HMAC", ex);
            }
        }

        public SimpleTextCaptcha(String[] parts) {
            this.nonce = new byte[16];
            ByteBuffer tmp = ByteBuffer.wrap(Base64.decode((String)parts[1]));
            tmp.get(this.nonce);
            this.a = tmp.getInt();
            this.b = tmp.getInt();
            this.time = tmp.getLong();
            this.result = this.a + this.b;
            this.hmac = Base64.decode((String)parts[2]);
        }

        @Override
        public String getID() {
            return this.getPrefix() + "." + Base64.encode((byte[])this.hmac);
        }

        protected String getPrefix() {
            ByteBuffer tmp = ByteBuffer.allocate(this.nonce.length + 4 + 4 + 8);
            tmp.put(this.nonce);
            tmp.putInt(this.a);
            tmp.putInt(this.b);
            tmp.putLong(this.time);
            return "simple-text." + Base64.encode((byte[])tmp.array());
        }

        @Override
        public String getCaptchaRequest(XMPPResourceConnection session) {
            return "Solve: " + String.valueOf(this.a) + " + " + String.valueOf(this.b);
        }

        public String getCaptchaRequest() {
            return "Solve: " + String.valueOf(this.a) + " + " + String.valueOf(this.b);
        }

        @Override
        public int getErrorCounter() {
            return this.errorCounter;
        }

        @Override
        public void incraseErrorCounter() {
            ++this.errorCounter;
        }

        @Override
        public boolean isResponseValid(XMPPResourceConnection session, String response) {
            return this.isResponseValid(() -> {
                String secret = SimpleTextCaptcha.getSecret(session);
                return new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            }, response);
        }

        public boolean isResponseValid(Supplier<SecretKeySpec> secretKeySpecSupplier, String response) {
            if (response == null) {
                return false;
            }
            try {
                String responseResult = response.trim();
                if (!String.valueOf(this.result).equals(responseResult)) {
                    return false;
                }
                if (this.time > System.currentTimeMillis() || System.currentTimeMillis() - this.time > this.timeout.toMillis()) {
                    return false;
                }
                byte[] calculated = SimpleTextCaptcha.calculateHMac((this.getPrefix() + "." + responseResult).getBytes(StandardCharsets.UTF_8), secretKeySpecSupplier.get());
                return Arrays.equals(this.hmac, calculated);
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    public static interface CaptchaItem {
        public String getID();

        public String getCaptchaRequest(XMPPResourceConnection var1);

        public int getErrorCounter();

        public void incraseErrorCounter();

        public boolean isResponseValid(XMPPResourceConnection var1, String var2);
    }
}

