/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SaslAuth2;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:bind:0", parent=SessionManager.class, active=false)
public class Bind2
implements SaslAuth2.Inline {
    public static final String XMLNS = "urn:xmpp:bind:0";
    private static final Logger log = Logger.getLogger(Bind2.class.getName());
    @Inject
    private List<SaslAuth2.Inline> inlines;

    public List<SaslAuth2.Inline> getInlines() {
        return this.inlines;
    }

    public void setInlines(List<SaslAuth2.Inline> inlines) {
        this.inlines = inlines.stream().filter(it -> !(it instanceof Bind2)).collect(Collectors.toList());
    }

    @Override
    public boolean canHandle(XMPPResourceConnection connection, Element el) {
        return el.getName() == "bind" && el.getXMLNS() == XMLNS && connection.isAuthorized() && connection.getResource() == null;
    }

    @Override
    public Element[] supStreamFeatures(SaslAuth2.Inline.Action action) {
        if (action != SaslAuth2.Inline.Action.sasl2) {
            return null;
        }
        Element bind = new Element("bind");
        bind.setXMLNS(XMLNS);
        Element inlineEl = new Element("inline");
        bind.addChild((XMLNodeIfc)inlineEl);
        for (SaslAuth2.Inline inline : this.inlines) {
            Element[] features = inline.supStreamFeatures(SaslAuth2.Inline.Action.bind2);
            if (features == null) continue;
            for (Element feature : features) {
                inlineEl.addChild((XMLNodeIfc)feature);
            }
        }
        return new Element[]{bind};
    }

    @Override
    public CompletableFuture<SaslAuth2.Inline.Result> process(XMPPResourceConnection session, JID _jid, Element action) {
        if (session == null) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.UNEXPECTED_REQUEST));
        }
        if (!session.isAuthorized()) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.NOT_AUTHORIZED));
        }
        StringBuilder resourceBuilder = new StringBuilder();
        String tag = this.parseTag(action);
        if (tag != null) {
            resourceBuilder.append(tag);
            resourceBuilder.append("/");
        }
        SaslAuth2.UserAgent userAgent = (SaslAuth2.UserAgent)session.getSessionData("user-agent-key");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            if (userAgent != null && userAgent.getId() != null) {
                md.update(userAgent.getId().getBytes(StandardCharsets.UTF_8));
            } else {
                md.update(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            }
            resourceBuilder.append(Base64.encode((byte[])md.digest()), 0, 12);
            JID boundJID = session.getJID().copyWithResource(resourceBuilder.toString());
            Element response = new Element("bound");
            response.setXMLNS(XMLNS);
            CompletionStage<SaslAuth2.Inline.Result> result = CompletableFuture.completedFuture(new SaslAuth2.Inline.Result(null, true));
            List features = action.getChildren();
            if (features != null) {
                for (Element feature : features) {
                    for (SaslAuth2.Inline inline : this.inlines) {
                        if (!inline.canHandle(session, feature)) continue;
                        result = result.thenCompose(r -> {
                            if (r.element != null) {
                                response.addChild((XMLNodeIfc)r.element);
                            }
                            if (r.shouldContinue) {
                                return inline.process(session, boundJID, feature);
                            }
                            return CompletableFuture.completedFuture(new SaslAuth2.Inline.Result(null, false));
                        });
                    }
                }
            }
            session.setResource(resourceBuilder.toString());
            session.putSessionData("Session-Set", "true");
            return result.thenApply(r -> {
                if (r.element != null) {
                    response.addChild((XMLNodeIfc)r.element);
                }
                return new SaslAuth2.Inline.Result(response, true);
            });
        }
        catch (NotAuthorizedException ex) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.NOT_AUTHORIZED));
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.WARNING, "stringprep problem with the server generated resource: {0}", resourceBuilder.toString());
            return CompletableFuture.failedFuture(new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
        catch (NoSuchAlgorithmException e) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    private String parseTag(Element action) {
        Element tagEl = action.getChild("tag");
        return tagEl != null ? tagEl.getCData() : null;
    }
}

