/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.StanzaSourceChecker;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.jid.JID;

@Bean(name="addressing-sanitizer", parent=SessionManager.class, active=true)
public class AddressingSanitizer
extends XMPPProcessor
implements XMPPPreprocessorIfc {
    private static final Logger log = Logger.getLogger(AddressingSanitizer.class.getName());
    private static final String[] COMPRESS_PATH = new String[]{"compress"};
    @Inject
    private StanzaSourceChecker stanzaSourceChecker;

    @Override
    public String id() {
        return "addressing-sanitizer";
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        block11: {
            if (packet.getServerAuthorisedStanzaFrom().isPresent()) {
                this.sanitizePacket(packet, packet.getServerAuthorisedStanzaFrom().get());
                return false;
            }
            if (session == null && this.stanzaSourceChecker.isPacketFromConnectionManager(packet)) {
                return true;
            }
            if (session == null || session.isServerSession() || !session.isAuthorized() || C2SDeliveryErrorProcessor.isDeliveryError(packet)) {
                return false;
            }
            try {
                if (!session.getConnectionId().equals((Object)packet.getPacketFrom())) break block11;
                if (session.isResourceSet() || packet.isXMLNSStaticStr(Iq.IQ_BIND_PATH, "urn:ietf:params:xml:ns:xmpp-bind") || packet.isXMLNSStaticStr(COMPRESS_PATH, "http://jabber.org/protocol/compress")) {
                    JID from_jid = session.getJID();
                    if (from_jid != null) {
                        this.sanitizePacket(packet, from_jid);
                    } else {
                        log.log(Level.WARNING, "Session is authenticated but session.getJid() is empty: {0}", packet.toStringSecure());
                    }
                    break block11;
                }
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must bind the resource first: http://www.xmpp.org/rfcs/rfc3920.html#bind", true));
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Session details: JID={0}, connectionId={1}, sessionId={2}", new Object[]{session.getjid(), session.getConnectionId(), session.getSessionId()});
                }
                return true;
            }
            catch (PacketErrorTypeException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Ignoring packet with an error to non-existen user session: {0}", packet.toStringSecure());
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Packet preprocessing exception: ", e);
                return false;
            }
        }
        return false;
    }

    protected void sanitizePacket(Packet packet, JID stanzaFrom) {
        Objects.requireNonNull(packet);
        Objects.requireNonNull(stanzaFrom);
        if ("message" == packet.getElemName() && packet.getStanzaTo() == null) {
            packet.initVars(packet.getStanzaFrom(), stanzaFrom.copyWithoutResource());
        }
        if (packet.getElemName() == "presence" && StanzaType.getSubsTypes().contains((Object)packet.getType()) && (packet.getStanzaFrom() == null || !stanzaFrom.getBareJID().equals((Object)packet.getStanzaFrom().getBareJID()) || packet.getStanzaFrom().getResource() != null)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting correct from attribute: {0}", stanzaFrom);
            }
            packet.initVars(stanzaFrom.copyWithoutResource(), packet.getStanzaTo());
        } else if (packet.getStanzaFrom() == null || (packet.getElemName() == "presence" && !StanzaType.getSubsTypes().contains((Object)packet.getType()) || packet.getElemName() != "presence") && !stanzaFrom.equals((Object)packet.getStanzaFrom())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting correct from attribute: {0}", stanzaFrom);
            }
            packet.initVars(stanzaFrom, packet.getStanzaTo());
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Skipping setting correct from attribute: {0}, is already correct.", packet.getStanzaFrom());
            }
            packet.initVars(packet.getStanzaFrom(), packet.getStanzaTo());
        }
    }
}

