/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.processing;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.processing.QueueItem;

public abstract class WorkerThread
extends Thread {
    protected static final Logger log = Logger.getLogger(WorkerThread.class.getName());
    private long averageProcessingTime = 0L;
    private LinkedBlockingQueue<QueueItem> queue = null;
    private long runsCnt = 0L;
    private boolean stopped = false;

    public abstract WorkerThread getNewInstance();

    public abstract void process(QueueItem var1);

    public long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    public long getRunsCounter() {
        return this.runsCnt;
    }

    public boolean offer(QueueItem item) {
        return this.queue.offer(item);
    }

    @Override
    public void run() {
        QueueItem item = null;
        while (!this.stopped) {
            block4: {
                try {
                    item = this.queue.take();
                    long start = System.currentTimeMillis();
                    this.process(item);
                    long end = System.currentTimeMillis() - start;
                    if (end > 0L) {
                        this.averageProcessingTime = (this.averageProcessingTime + end) / 2L;
                    }
                }
                catch (Exception e) {
                    if (this.stopped) break block4;
                    log.log(Level.SEVERE, this.getClass().getName() + ",(" + this.getName() + ") Exception during packet processing: " + String.valueOf(item), e);
                }
            }
            ++this.runsCnt;
        }
    }

    public void setQueueMaxSize(int maxSize) {
        LinkedBlockingQueue<QueueItem> oldQueue = this.queue;
        this.queue = new LinkedBlockingQueue(maxSize);
        if (oldQueue != null) {
            this.queue.addAll(oldQueue);
        }
    }

    public int size() {
        return this.queue.size();
    }

    public void shutdown() {
        this.stopped = true;
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

