/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import tigase.util.StringUtilities;
import tigase.util.log.LogWithStackTraceEntry;
import tigase.util.ui.console.AnsiColor;

public class LogFormatter
extends Formatter {
    public static final Map<Integer, LogWithStackTraceEntry> errors = new ConcurrentSkipListMap<Integer, LogWithStackTraceEntry>();
    static final DateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static int DATE_TIME_LEN = 26;
    private static int LEVEL_OFFSET = 7;
    private static int METHOD_OFFSET = 37;
    private static int THREAD_OFFSET = 25;
    protected Date timestamp = new Date();
    private boolean colorful = !Boolean.getBoolean("disable_logger_color");

    public LogFormatter() {
    }

    public LogFormatter(boolean colorful) {
        this.colorful = colorful;
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(200);
        int colorOffset = 0;
        this.timestamp.setTime(record.getMillis());
        colorOffset += this.setColor(sb, AnsiColor.GREEN_BOLD_BRIGHT);
        sb.append('[').append(simple.format(this.timestamp)).append(']');
        StringUtilities.padStringToColumn((StringBuilder)sb, (String)record.getLevel().toString(), (StringUtilities.JUSTIFY)StringUtilities.JUSTIFY.LEFT, (int)(DATE_TIME_LEN + LEVEL_OFFSET + (colorOffset += this.setColor(sb, AnsiColor.CYAN))), (char)' ', (String)" [", (String)"]");
        StringUtilities.padStringToColumn((StringBuilder)sb, (String)Thread.currentThread().getName(), (StringUtilities.JUSTIFY)StringUtilities.JUSTIFY.RIGHT, (int)(DATE_TIME_LEN + LEVEL_OFFSET + THREAD_OFFSET + (colorOffset += this.setColor(sb, AnsiColor.RESET))), (char)' ', (String)" [", (String)" ]");
        StringUtilities.padStringToColumn((StringBuilder)sb, (String)this.getClassMethodName(record), (StringUtilities.JUSTIFY)StringUtilities.JUSTIFY.LEFT, (int)(DATE_TIME_LEN + LEVEL_OFFSET + THREAD_OFFSET + METHOD_OFFSET + (colorOffset += this.setColor(sb, AnsiColor.BLUE_BOLD))), (char)' ', (String)" ", (String)": ");
        this.setColor(sb, AnsiColor.RESET);
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            String stackTrace = LogFormatter.fillThrowable(record);
            sb.append(stackTrace);
            this.addError(record.getThrown(), stackTrace, sb.toString());
        }
        return sb.append("\n").toString();
    }

    protected void addError(Throwable thrown, String stack, String log_msg) {
        errors.computeIfAbsent(stack.hashCode(), integer -> {
            String msg = thrown.getMessage();
            if (msg == null) {
                msg = thrown.toString();
            }
            return new LogWithStackTraceEntry(msg, log_msg);
        }).increment();
    }

    private int setColor(StringBuilder sb, AnsiColor color) {
        if (this.colorful && AnsiColor.isCompatible()) {
            sb.append(color);
            return color.toString().length();
        }
        return 0;
    }

    private static String fillThrowable(LogRecord record) {
        return LogFormatter.fillThrowable(record.getThrown());
    }

    public static String fillThrowable(Throwable throwable) {
        StringWriter sw = new StringWriter();
        if (throwable != null) {
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            throwable.printStackTrace(pw);
            pw.close();
        }
        return sw.toString();
    }

    private String getClassMethodName(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (record.getSourceClassName() != null) {
            String className = "";
            className = record.getSourceClassName();
            int idx = className.lastIndexOf(46);
            if (idx >= 0) {
                className = className.substring(idx + 1);
            }
            sb.append(className);
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".").append(record.getSourceMethodName()).append("()");
        }
        return sb.toString();
    }
}

