/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.XMPPServer;
import tigase.sys.TigaseRuntime;
import tigase.util.Version;

public class DependencyChecker {
    private static final Logger log = Logger.getLogger(DependencyChecker.class.getCanonicalName());

    public static void checkDependencies(Class clazz) {
        if (XMPPServer.isOSGi()) {
            return;
        }
        try {
            Enumeration<URL> manifestUrls = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                URL url = manifestUrls.nextElement();
                InputStream is = url.openStream();
                try {
                    Manifest manifest = new Manifest(is);
                    String dependencies = manifest.getMainAttributes().getValue("Tigase-Required-Dependencies");
                    if (dependencies == null) continue;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Found required dependencies " + dependencies + " in " + String.valueOf(url));
                    }
                    for (String dependency : dependencies.split(",")) {
                        String[] parts = dependency.split("=");
                        String name = parts[0];
                        Version version = Version.of((String)parts[1]);
                        Package p = Package.getPackage(name);
                        if (p == null) {
                            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"Required package " + name + " is inaccessible. Make sure that all required jars are available in your classpath."});
                        }
                        if (p.getImplementationVersion() == null) {
                            log.log(Level.FINE, "could not check " + name + " dependency version as package version is not set");
                            continue;
                        }
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "looking for " + name + " in version " + String.valueOf(version) + " and found " + p.getImplementationVersion());
                        }
                        if (version.compareTo(Version.of((String)p.getImplementationVersion())) <= 0) continue;
                        TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{p.getImplementationTitle() + " is available in version " + p.getImplementationVersion() + " while " + clazz.getPackage().getImplementationTitle() + " " + clazz.getPackage().getImplementationVersion() + " requires version >= " + String.valueOf(version)});
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read META-INF/MANIFEST.MF", ex);
        }
    }
}

