/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.AuthenticatorSelectorManager;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.util.common.TimerTask;

public abstract class AuthenticationProcessor
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(AuthenticationProcessor.class.getName());
    private static final String AUTHENTICATION_TIMER_KEY = "AUTHENTICATION_TIMER_KEY";
    @Inject
    protected static AuthenticatorSelectorManager authenticatorSelectorManager;
    @ConfigField(desc="Authentication timeout for S2S connections")
    private long authenticationTimeOut = 30L;

    @Override
    public void serviceStarted(S2SIOService serv) {
        log.log(Level.FINEST, "s2s connection opened, isHandshaking: {1} [{0}]", new Object[]{serv, serv.isHandshakingOnly()});
        if (serv.getSessionData().get(AUTHENTICATION_TIMER_KEY) == null) {
            AuthenticationTimer task = new AuthenticationTimer(serv);
            this.handler.addTimerTask(task, this.authenticationTimeOut, TimeUnit.SECONDS);
            serv.getSessionData().put(AUTHENTICATION_TIMER_KEY, task);
        }
    }

    abstract String getMethodName();

    abstract void restartAuth(Packet var1, S2SIOService var2, Queue<Packet> var3);

    abstract boolean canHandle(Packet var1, S2SIOService var2, Queue<Packet> var3);

    static class AuthenticationTimer
    extends TimerTask {
        private S2SIOService serv = null;

        private AuthenticationTimer(S2SIOService serv) {
            this.serv = serv;
        }

        @Override
        public void run() {
            if (!this.serv.isAuthenticated() && this.serv.isConnected()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Connection not authenticated within timeout, stopping: {0}", this.serv);
                }
                authenticatorSelectorManager.markConnectionAsFailed("timeout", this.serv);
                this.serv.stop();
            }
        }
    }
}

