/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.RegistrationThrottling;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.JID;

@Bean(name="registration-throttling-processor", active=true)
public class RegistrationThrottlingProcessor
implements XMPPIOProcessor {
    public static final String ID = "registration-throttling-processor";
    private static final Logger log = Logger.getLogger(RegistrationThrottlingProcessor.class.getCanonicalName());
    private static final String[] REGISTER_PATH = Iq.IQ_QUERY_PATH;
    private static final String[] REMOVE_PATH = new String[]{"iq", "query", "remove"};
    private static final String[] USERNAME_PATH = new String[]{"iq", "query", "username"};
    private static final String XMLNS = "jabber:iq:register";
    @Inject(bean="service")
    private ClientConnectionManager connectionManager;
    @Inject(bean="registration-throttling")
    private RegistrationThrottling throttler;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        return new Element[0];
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        if (packet.getType() != StanzaType.set || !XMLNS.equals(packet.getAttributeStaticStr(REGISTER_PATH, "xmlns"))) {
            return false;
        }
        JID to = packet.getStanzaTo();
        if (!(to == null || to.getLocalpart() == null && this.connectionManager.isLocalDomain(to.getDomain()))) {
            return false;
        }
        if (packet.getElement().findChild(REMOVE_PATH) != null) {
            return false;
        }
        if (this.throttler.checkLimits(service, packet)) {
            return false;
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "User from IP {0} exceeded registration limit trying to register account {1}", new Object[]{service.getRemoteAddress(), packet.getElemCDataStaticStr(USERNAME_PATH)});
            }
            Packet errorPacket = Authorization.POLICY_VIOLATION.getResponseMessage(packet, "Policy violation", true);
            Element streamError = new Element("policy-violation");
            streamError.setXMLNS("urn:ietf:params:xml:ns:xmpp-stanzas");
            String result = this.connectionManager.xmppStreamError(service, Arrays.asList(streamError));
            service.writeRawData(errorPacket.getElement().toString() + result + "</stream:stream>");
        }
        catch (IOException | PacketErrorTypeException ex) {
            log.log(Level.FINEST, "Exception while registration request to check policy violation");
        }
        service.stop();
        return true;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        return false;
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
    }

    @Override
    public void processCommand(XMPPIOService service, Packet packet) {
    }

    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        return false;
    }

    @Override
    public void streamError(XMPPIOService service, StreamError streamError) {
    }
}

